/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

public class Base62 {
    private static final char[] ALPHABET_BASE = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    private static final int BASE_COUNT = 62;

    public static String encodeToString(long source) {
        StringBuilder sb = new StringBuilder();
        if (source == 0L) {
            sb.append('a');
        }
        while (source > 0L) {
            long mod = source % 62L;
            sb.append(ALPHABET_BASE[(int)mod]);
            source /= 62L;
        }
        return sb.toString();
    }

    public static long decodeFromString(String str) {
        return Base62.decode(str.toCharArray());
    }

    private static long decode(char[] chars) {
        long n = 0L;
        int pow = 0;
        for (char item : chars) {
            int i = 0;
            if (item >= 'a' && item <= 'z') {
                i = item - 97;
            }
            if (item >= '0' && item <= '9') {
                i = item - 48 + 26;
            }
            if (item >= 'A' && item <= 'Z') {
                i = item - 65 + 36;
            }
            n += (long)i * (long)Math.pow(62.0, pow);
            ++pow;
        }
        return n;
    }
}

