/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;

public class CryptoUtil {
    public static byte[] cipher(String algorithm, String keyAlgorithm, byte[] data, byte[] key, int opmode, AlgorithmParameterSpec params) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = Cipher.getInstance(algorithm);
        SecretKeySpec keySpec = new SecretKeySpec(key, keyAlgorithm);
        if (params == null) {
            cipher.init(opmode, keySpec);
        } else {
            cipher.init(opmode, (Key)keySpec, params);
        }
        return cipher.doFinal(data);
    }

    public static byte[] cipher(String algorithm, String keyAlgorithm, byte[] data, byte[] key, int opmode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        return CryptoUtil.cipher(algorithm, keyAlgorithm, data, key, opmode, null);
    }

    public static byte[] md(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(data);
        return md.digest();
    }

    public static byte[] mac(byte[] data, byte[] salt, String algorithm, String keyAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(salt, keyAlgorithm));
        return mac.doFinal(data);
    }

    public static byte[] secretKeyFactory(String algorithm, KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return SecretKeyFactory.getInstance(algorithm).generateSecret(keySpec).getEncoded();
    }

    public static KeyPair keyPairGenerator(String algorithm, int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keysize);
        return keyPairGenerator.generateKeyPair();
    }
}

