/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;

public class DatetimeUtil {
    public static String format(String pattern, TemporalAccessor temporal) {
        return DatetimeUtil.format(pattern, Locale.getDefault(Locale.Category.FORMAT), temporal);
    }

    public static String format(String pattern, Locale locale, TemporalAccessor temporal) {
        return DateTimeFormatter.ofPattern(pattern, locale).format(temporal);
    }

    public static TemporalAccessor parse(String pattern, String timestamp) {
        return DatetimeUtil.parse(pattern, Locale.getDefault(Locale.Category.FORMAT), timestamp);
    }

    public static TemporalAccessor parse(String pattern, Locale locale, String timestamp) {
        return DateTimeFormatter.ofPattern(pattern, locale).parse(timestamp);
    }

    public static long toEpochSecond(TemporalAccessor temporal) {
        return Instant.from(temporal).getEpochSecond();
    }

    public static long toEpochMilliSecond(TemporalAccessor temporal) {
        return Instant.from(temporal).toEpochMilli();
    }

    public static ZonedDateTime parseEpochSecond(long epoch, ZoneId zoneId) {
        return Instant.ofEpochSecond(epoch).atZone(zoneId);
    }

    public static ZonedDateTime parseEpochMilliSecond(long milli, ZoneId zoneId) {
        return Instant.ofEpochMilli(milli).atZone(zoneId);
    }
}

