/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class MathUtil {
    public static BigDecimal maxDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).max(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigInteger maxInteger(List<BigInteger> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).max(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigDecimal minDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).min(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigInteger minInteger(List<BigInteger> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).min(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigDecimal avgDecimal(List<BigDecimal> nums, RoundingMode roundingMode) {
        return nums.stream().map(Objects::requireNonNull).reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(nums.size()), roundingMode);
    }

    public static double avgDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().mapToDouble(BigDecimal::doubleValue).average().orElseThrow();
    }

    public static BigDecimal avgInteger(List<BigInteger> nums, RoundingMode roundingMode) {
        BigInteger sum = nums.stream().map(Objects::requireNonNull).reduce(BigInteger.ZERO, BigInteger::add);
        return new BigDecimal(sum).divide(BigDecimal.valueOf(nums.size()), roundingMode);
    }

    public static String format(String precisionPattern, double number) {
        return new DecimalFormat(precisionPattern).format(number);
    }
}

