/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;

public class ReflectionUtil {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Method[] EMPTY_METHOD_ARRAY = new Method[0];
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final MethodFilter USER_DECLARED_METHODS = method -> !method.isBridge() && !method.isSynthetic();

    public static <T> T newInstance(Class<T> clazz) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return ReflectionUtil.newInstance(clazz, EMPTY_CLASS_ARRAY, null);
    }

    public static <T> T newInstance(Class<T> clazz, Class<?>[] parameterTypes, Object[] initArgs) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        return clazz.getDeclaredConstructor(parameterTypes).newInstance(initArgs);
    }

    public static <T> Method findMethod(Class<T> clazz, String methodName) throws NoSuchMethodException, SecurityException {
        return ReflectionUtil.findMethod(clazz, methodName, EMPTY_CLASS_ARRAY);
    }

    public static <T> Method findMethod(Class<T> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        return clazz.getDeclaredMethod(methodName, parameterTypes);
    }

    public static <T> Object invokeMethod(T t, String methodName, Object ... args) throws ReflectiveOperationException, RuntimeException {
        return ReflectionUtil.invokeMethod(t, methodName, ReflectionUtil.getParameterTypes(args), args);
    }

    public static <T> Object invokeMethod(T t, String methodName, Class<?>[] parameterTypes, Object ... args) throws ReflectiveOperationException, RuntimeException {
        Method method = ReflectionUtil.findMethod(t.getClass(), methodName, parameterTypes);
        return ReflectionUtil.invokeMethod(method, t, args);
    }

    public static Class<?>[] getParameterTypes(Object[] args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i].getClass();
        }
        return types;
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        return method.invoke(target, args);
    }

    public static Object invokeMethod(Method method, Object target) throws InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        return ReflectionUtil.invokeMethod(method, target, EMPTY_OBJECT_ARRAY);
    }

    public static Method[] getDeclaredMethods(Class<?> clazz) throws SecurityException {
        Method[] declaredMethods = clazz.getDeclaredMethods();
        return declaredMethods.length == 0 ? declaredMethods : (Method[])declaredMethods.clone();
    }

    public static Method[] getAllDeclaredMethods(Class<?> clazz) throws SecurityException, IllegalAccessException {
        ArrayList methods = new ArrayList(32);
        ReflectionUtil.doWithMethods(clazz, methods::add);
        return methods.toArray(EMPTY_METHOD_ARRAY);
    }

    private static void doWithMethods(Class<?> clazz, MethodCallback mc) throws SecurityException, IllegalAccessException {
        ReflectionUtil.doWithMethods(clazz, mc, null);
    }

    private static void doWithMethods(Class<?> clazz, MethodCallback mc, MethodFilter mf) throws SecurityException, IllegalAccessException {
        Method[] methods = ReflectionUtil.getDeclaredMethods(clazz);
        for (Method method : methods) {
            if (mf != null && !mf.matches(method)) continue;
            mc.doWith(method);
        }
        if (clazz.getSuperclass() != null && (mf != USER_DECLARED_METHODS || clazz.getSuperclass() != Object.class)) {
            ReflectionUtil.doWithMethods(clazz.getSuperclass(), mc, mf);
        } else if (clazz.isInterface()) {
            for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
                ReflectionUtil.doWithMethods(genericDeclaration, mc, mf);
            }
        }
    }

    public static Field findField(Class<?> clazz, String name, Class<?> type) throws NoSuchFieldException {
        for (Class<?> searchType = clazz; Object.class != searchType && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = ReflectionUtil.getDeclaredFields(searchType)) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return field;
            }
        }
        throw new NoSuchFieldException();
    }

    public static Field[] getDeclaredFields(Class<?> clazz) throws SecurityException {
        return clazz.getDeclaredFields();
    }

    public static <T> Object getField(Field field, T target) throws IllegalArgumentException, IllegalAccessException {
        return field.get(target);
    }

    public static <T, V> void setField(Field field, T target, V value) throws IllegalArgumentException, IllegalAccessException {
        field.set(target, value);
    }

    public static Parameter[] getParameters(Method method) {
        return method.getParameters();
    }

    @FunctionalInterface
    private static interface MethodCallback {
        public void doWith(Method var1) throws IllegalArgumentException, IllegalAccessException;
    }

    @FunctionalInterface
    private static interface MethodFilter {
        public boolean matches(Method var1);

        default public MethodFilter and(MethodFilter next) {
            return method -> this.matches(method) && next.matches(method);
        }
    }
}

