/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.seppiko.commons.utils.http.HttpClientException;
import org.seppiko.commons.utils.http.HttpMethod;

public class HttpClientUtil {
    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, LinkedHashMap<String, ArrayList<String>> headers, String requestBody) throws URISyntaxException, IllegalArgumentException, NullPointerException {
        String[] headerStringArray = headers != null ? (String[])HttpClientUtil.headerParser(headers).toArray(String[]::new) : new String[]{};
        HttpRequest.BodyPublisher requestBodyPublisher = requestBody != null ? HttpRequest.BodyPublishers.ofString(requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headerStringArray, requestBodyPublisher);
    }

    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, LinkedHashMap<String, ArrayList<String>> headers, InputStream requestBody) throws URISyntaxException {
        String[] headerStringArray = headers != null ? (String[])HttpClientUtil.headerParser(headers).toArray(String[]::new) : new String[]{};
        HttpRequest.BodyPublisher requestBodyPublisher = requestBody != null ? HttpRequest.BodyPublishers.ofInputStream(() -> requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headerStringArray, requestBodyPublisher);
    }

    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, LinkedHashMap<String, ArrayList<String>> headers, byte[] requestBody) throws URISyntaxException {
        String[] headerStringArray = headers != null ? (String[])HttpClientUtil.headerParser(headers).toArray(String[]::new) : new String[]{};
        HttpRequest.BodyPublisher requestBodyPublisher = requestBody != null ? HttpRequest.BodyPublishers.ofByteArray(requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headerStringArray, requestBodyPublisher);
    }

    public static HttpResponse<String> getResponseString(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        try {
            if (proxy != null) {
                return HttpClientUtil.getResponseProxyRaw(req, HttpResponse.BodyHandlers.ofString(), proxy);
            }
            return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException ex) {
            throw new HttpClientException(ex.getMessage());
        }
    }

    public static HttpResponse<byte[]> getResponseByteArray(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        try {
            if (proxy != null) {
                return HttpClientUtil.getResponseProxyRaw(req, HttpResponse.BodyHandlers.ofByteArray(), proxy);
            }
            return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofByteArray());
        }
        catch (IOException | InterruptedException ex) {
            throw new HttpClientException(ex.getMessage());
        }
    }

    public static HttpResponse<InputStream> getResponseInputStream(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        try {
            if (proxy != null) {
                return HttpClientUtil.getResponseProxyRaw(req, HttpResponse.BodyHandlers.ofInputStream(), proxy);
            }
            return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofInputStream());
        }
        catch (IOException | InterruptedException ex) {
            throw new HttpClientException(ex.getMessage());
        }
    }

    private static ArrayList<String> headerParser(LinkedHashMap<String, ArrayList<String>> headers) {
        ArrayList<String> headerList = new ArrayList<String>();
        headers.forEach((key, value) -> value.forEach(e -> headerList.add(key + ":" + e)));
        return headerList;
    }

    private static HttpRequest getRequestRaw(URI uri, HttpMethod method, int timeout, String[] headers, HttpRequest.BodyPublisher requestBody) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri).method(method.name(), requestBody);
        if (headers.length > 0) {
            builder = builder.headers(headers);
        }
        return builder.timeout(Duration.ofSeconds(timeout)).build();
    }

    private static <T> HttpResponse<T> getResponseRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        return HttpClient.newHttpClient().send(req, responseBodyHandler);
    }

    private static <T> HttpResponse<T> getResponseProxyRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler, InetSocketAddress proxy) throws IOException, InterruptedException {
        return HttpClient.newBuilder().proxy(ProxySelector.of(proxy)).build().send(req, responseBodyHandler);
    }
}

