/*
 * Copyright 2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils;

/**
 * Number Util
 *
 * @author Leonard Woo
 */
public class NumberUtil {

  /**
   * Test String is number
   *
   * @param num number
   * @return true is yes
   */
  public static boolean isNumber(String num) {
    return num.matches("\\d+");
  }

  /**
   * test num between min and max
   *
   * @param num number
   * @param min minimum number
   * @param max maximum number
   * @return true = it is
   */
  public static boolean between(byte num, byte min, byte max) {
    return num >= min && num <= max;
  }

  /**
   * test num between min and max
   *
   * @param num number
   * @param min minimum number
   * @param max maximum number
   * @return true = it is
   */
  public static boolean between(short num, short min, short max) {
    return num >= min && num <= max;
  }

  /**
   * test num between min and max
   *
   * @param num number
   * @param min minimum number
   * @param max maximum number
   * @return true = it is
   */
  public static boolean between(int num, int min, int max) {
    return num >= min && num <= max;
  }

  /**
   * test num between min and max
   *
   * @param num number
   * @param min minimum number
   * @param max maximum number
   * @return true = it is
   */
  public static boolean between(long num, long min, long max) {
    return num >= min && num <= max;
  }

  /**
   * test num between min and max
   *
   * @param num number
   * @param min minimum number
   * @param max maximum number
   * @return true = it is
   */
  public static boolean between(float num, float min, float max) {
    return num >= min && num <= max;
  }

  /**
   * test num between min and max
   *
   * @param num number
   * @param min minimum number
   * @param max maximum number
   * @return true = it is
   */
  public static boolean between(double num, double min, double max) {
    return num >= min && num <= max;
  }

  /**
   * byte array to unsigned int array
   *
   * @param src byte array
   * @return unsigned int array
   */
  public static int[] toUnsignedIntArray(byte[] src) {
    int[] dst = new int[src.length];
    for (int i = 0; i < src.length; i++) {
      dst[i] = Byte.toUnsignedInt(src[i]);
    }
    return dst;
  }

  /**
   * int array to unsigned long array
   *
   * @param src int array
   * @return unsigned long array
   */
  public static long[] toUnsignedLongArray(int[] src) {
    long[] dst = new long[src.length];
    for (int i = 0; i < src.length; i++) {
      dst[i] = Integer.toUnsignedLong(src[i]);
    }
    return dst;
  }
}
