/*
 * Copyright 2021 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils;

import java.util.zip.CRC32C;

/**
 * CRC Util
 *
 * @author Leonard Woo
 */
public class CRCUtil {

  public static class CRC16C {
    private static CRC16 crc16;

    static {
      crc16 = new CRC16();
    }

    public static long encode(byte[] data) {
      crc16.update(data);
      return crc16.getValue();
    }
  }

  public static class CRC32 {
    private static CRC32C crc32;

    static {
      crc32 = new CRC32C();
    }

    public static long encode(byte[] data) {
      crc32.update(data);
      return crc32.getValue();
    }
  }
}
