/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.seppiko.commons.utils.ObjectUtil;

public class CryptoUtil {
    public static byte[] cipher(String algorithm, Provider provider, int opmode, Key key, AlgorithmParameterSpec params, byte[] data) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher;
        Cipher cipher2 = cipher = ObjectUtil.isNull(provider) ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        if (ObjectUtil.isNull(params)) {
            cipher.init(opmode, key);
        } else {
            cipher.init(opmode, key, params);
        }
        return cipher.doFinal(data);
    }

    public static byte[] cipher(String algorithm, Provider provider, String keyAlgorithm, byte[] data, byte[] key, int opmode, AlgorithmParameterSpec params) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        SecretKeySpec keySpec = new SecretKeySpec(key, keyAlgorithm);
        return CryptoUtil.cipher(algorithm, provider, opmode, keySpec, params, data);
    }

    public static byte[] md(String algorithm, byte[] data) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(data);
        return md.digest();
    }

    public static byte[] mac(byte[] data, byte[] salt, String algorithm, String keyAlgorithm) throws NoSuchAlgorithmException, InvalidKeyException {
        Mac mac = Mac.getInstance(algorithm);
        mac.init(new SecretKeySpec(salt, keyAlgorithm));
        return mac.doFinal(data);
    }

    public static byte[] secretKeyFactory(String algorithm, KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return SecretKeyFactory.getInstance(algorithm).generateSecret(keySpec).getEncoded();
    }

    public static KeyPair keyPairGenerator(String algorithm, int keysize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm);
        keyPairGenerator.initialize(keysize);
        return keyPairGenerator.generateKeyPair();
    }

    public static byte[] signatureSign(String algorithm, PrivateKey privateKey, byte[] rawData) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(algorithm);
        signature.initSign(privateKey);
        signature.update(rawData);
        return signature.sign();
    }

    public static boolean signatureVerify(String algorithm, PublicKey publicKey, byte[] rawData, byte[] signedData) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature signature = Signature.getInstance(algorithm);
        signature.initVerify(publicKey);
        signature.update(rawData);
        return signature.verify(signedData);
    }
}

