/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.seppiko.commons.utils.StringUtil;

public class MathUtil {
    public static BigDecimal maxDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).max(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigInteger maxInteger(List<BigInteger> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).max(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigDecimal minDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).min(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigInteger minInteger(List<BigInteger> nums) throws NoSuchElementException {
        return nums.stream().filter(Objects::nonNull).min(Comparator.comparing(n -> n)).orElseThrow();
    }

    public static BigDecimal avgDecimal(List<BigDecimal> nums, RoundingMode roundingMode) {
        return nums.stream().map(Objects::requireNonNull).reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(nums.size()), roundingMode);
    }

    public static double avgDecimal(List<BigDecimal> nums) throws NoSuchElementException {
        return nums.stream().mapToDouble(BigDecimal::doubleValue).average().orElseThrow();
    }

    public static BigDecimal avgInteger(List<BigInteger> nums, RoundingMode roundingMode) {
        BigInteger sum = nums.stream().map(Objects::requireNonNull).reduce(BigInteger.ZERO, BigInteger::add);
        return new BigDecimal(sum).divide(BigDecimal.valueOf(nums.size()), roundingMode);
    }

    public static String format(String precisionPattern, double number) {
        return new DecimalFormat(precisionPattern).format(number);
    }

    public static String convertDecimalTo(int num, char[] alphabet) {
        if (num < 1) {
            return null;
        }
        StringBuilder s = new StringBuilder();
        int length = alphabet.length;
        int n = num;
        while (n > 0) {
            int m = n % length;
            if (m == 0) {
                m = length;
            }
            s.insert(0, alphabet[m - 1]);
            n = (n - m) / length;
        }
        return s.toString();
    }

    public static Integer convertToDecimal(CharSequence num, char[] alphabet) {
        if (!StringUtil.hasText(num)) {
            return null;
        }
        int n = 0;
        int l = alphabet.length;
        int nl = num.length();
        for (int i = 0; i < nl; ++i) {
            int index = MathUtil.findIndex(num.charAt(i), alphabet) + 1;
            n += (int)Math.pow(l, nl - i - 1) * index;
        }
        return n;
    }

    private static int findIndex(char c, char[] chars) {
        for (int i = 0; i < chars.length; ++i) {
            if (c != chars[i]) continue;
            return i;
        }
        return -1;
    }
}

