/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class ObjectUtil {
    public static <T> T safeNull(T t, T defaultValue) {
        return ObjectUtil.isNull(t) ? defaultValue : t;
    }

    public static boolean isArray(Object obj) {
        return ObjectUtil.notNull(obj) && obj.getClass().isArray();
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static <T> boolean isNull(T obj) {
        return obj == null;
    }

    public static <T> boolean notNull(T obj) {
        return obj != null;
    }

    public static Object deepCopy(Object obj) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(obj);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bais);
        return ois.readObject();
    }
}

