/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.Charset;
import org.seppiko.commons.utils.Environment;

public class StreamUtil {
    public static InputStream findFileInputStream(Class<?> clazz, String pathname) {
        try {
            return new FileInputStream(StreamUtil.findFile(clazz, pathname));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static File findFile(Class<?> clazz, String pathname) {
        String _pathname = StreamUtil.getClassLoaderPath(clazz.getClassLoader(), pathname);
        _pathname = _pathname == null ? pathname : _pathname;
        return new File(pathname);
    }

    private static String getClassLoaderPath(ClassLoader cl, String path) {
        URL url = cl.getResource(path);
        return url == null ? null : url.getPath();
    }

    public static InputStream getStream(Class<?> clazz, String pathname) {
        return StreamUtil.getStream(StreamUtil.findFile(clazz, pathname));
    }

    public static InputStream getStream(String filepath) {
        return StreamUtil.getStream(new File(filepath));
    }

    public static InputStream getStream(File file) {
        try {
            return new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    public static BufferedReader loadString(String str) {
        return new BufferedReader(new StringReader(str));
    }

    public static BufferedReader loadReader(InputStream is) {
        return new BufferedReader(new InputStreamReader(is));
    }

    public static BufferedReader loadReader(InputStream is, Charset charset) {
        return new BufferedReader(new InputStreamReader(is, charset));
    }

    public static void exportOutputStream(byte[] bytes, OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        bos.write(bytes);
        bos.flush();
    }

    public static String readerToString(BufferedReader reader, boolean ignoreNewLine) throws IOException {
        StringBuilder sb = new StringBuilder();
        while (reader.ready()) {
            sb.append(reader.readLine());
            if (ignoreNewLine) continue;
            sb.append(Environment.NEW_LINE);
        }
        return sb.toString();
    }

    public static Writer writeFile(String pathname) throws IOException {
        return StreamUtil.writeFile(new File(pathname));
    }

    public static Writer writeFile(File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Can not create file");
        }
        return new FileWriter(file);
    }

    public static void toFile(byte[] b, File file) throws IOException {
        if (!file.exists() && !file.createNewFile()) {
            throw new IOException("Can not create file");
        }
        FileOutputStream os = new FileOutputStream(file);
        StreamUtil.exportOutputStream(b, os);
        ((OutputStream)os).close();
    }

    public static void copy(InputStream is, OutputStream os) throws IOException {
        is.transferTo(os);
        os.flush();
    }
}

