/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class NumberUtil {
    public static final int LATIN_DIGITS = 1;
    public static final int FULLWIDTH_DIGITS = 3;
    private static final char FULLWIDTH_PLUS = '\uff0b';
    private static final char FULLWIDTH_MINUS = '\uff0d';
    private static final char FULLWIDTH_FULL_STOP = '\uff0e';

    public static boolean between(byte num, byte min, byte max) {
        return num >= min && num <= max;
    }

    public static boolean between(short num, short min, short max) {
        return num >= min && num <= max;
    }

    public static boolean between(int num, int min, int max) {
        return num >= min && num <= max;
    }

    public static boolean between(long num, long min, long max) {
        return num >= min && num <= max;
    }

    public static boolean between(float num, float min, float max) {
        return num >= min && num <= max;
    }

    public static boolean between(double num, double min, double max) {
        return num >= min && num <= max;
    }

    public static boolean between(BigDecimal num, BigDecimal min, BigDecimal max) {
        return num.compareTo(min) >= 0 && num.compareTo(max) <= 0;
    }

    public static boolean between(BigInteger num, BigInteger min, BigInteger max) {
        return num.compareTo(min) >= 0 && num.compareTo(max) <= 0;
    }

    public static String format(String precisionPattern, double number) {
        return new DecimalFormat(precisionPattern).format(number);
    }

    public static int[] toUnsignedIntArray(byte[] src) {
        int[] dst = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Byte.toUnsignedInt(src[i]);
        }
        return dst;
    }

    public static int[] toUnsignedShortArray(short[] src) {
        int[] dst = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Short.toUnsignedInt(src[i]);
        }
        return dst;
    }

    public static long[] toUnsignedLongArray(int[] src) {
        long[] dst = new long[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Integer.toUnsignedLong(src[i]);
        }
        return dst;
    }

    public static String convert(CharSequence input, int outType) {
        if (NumberUtil.notDigit(input)) {
            throw new IllegalArgumentException("input is not number");
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal digit = new BigDecimal(input.toString().replaceFirst("^\\uFF0B", "+").replaceFirst("^\\uFF0D", "-").replaceFirst("\\uFF0E", "."));
        if (outType == 1) {
            sb.append(digit);
        } else if (outType == 3) {
            digit.toString().chars().forEach(i -> sb.append((char)(i - 48 + 65296)));
        } else {
            throw new IllegalArgumentException("outType is wrong");
        }
        return sb.toString();
    }

    private static boolean notDigit(CharSequence input) {
        for (char c : input.toString().toCharArray()) {
            if (NumberUtil.isNumeric(c)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNumeric(int ch) {
        return NumberUtil.between(ch, 48, 57) || NumberUtil.between(ch, 65296, 65305) || NumberUtil.isNumericSymbol(ch);
    }

    private static boolean isNumericSymbol(int ch) {
        return 46 == ch || 65294 == ch || 45 == ch || 65293 == ch || 43 == ch || 65291 == ch;
    }
}

