/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.seppiko.commons.utils.ObjectUtil;
import org.seppiko.commons.utils.http.HttpClientException;
import org.seppiko.commons.utils.http.HttpHeaders;
import org.seppiko.commons.utils.http.HttpMethod;

public class HttpClientUtil {
    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, HttpHeaders headers, String requestBody) throws URISyntaxException, IllegalArgumentException, NullPointerException {
        if (headers == null) {
            headers = HttpHeaders.NO_HEADERS;
        }
        HttpRequest.BodyPublisher requestBodyPublisher = ObjectUtil.notNull(requestBody) ? HttpRequest.BodyPublishers.ofString(requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headers.getHeaderList(), requestBodyPublisher);
    }

    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, HttpHeaders headers, InputStream requestBody) throws URISyntaxException {
        if (headers == null) {
            headers = HttpHeaders.NO_HEADERS;
        }
        HttpRequest.BodyPublisher requestBodyPublisher = ObjectUtil.notNull(requestBody) ? HttpRequest.BodyPublishers.ofInputStream(() -> requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headers.getHeaderList(), requestBodyPublisher);
    }

    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, HttpHeaders headers, byte[] requestBody) throws URISyntaxException {
        if (headers == null) {
            headers = HttpHeaders.NO_HEADERS;
        }
        HttpRequest.BodyPublisher requestBodyPublisher = ObjectUtil.notNull(requestBody) ? HttpRequest.BodyPublishers.ofByteArray(requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headers.getHeaderList(), requestBodyPublisher);
    }

    public static HttpResponse<String> getResponseString(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        try {
            return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofString(), proxy);
        }
        catch (IOException | InterruptedException ex) {
            throw new HttpClientException(ex.getMessage());
        }
    }

    public static HttpResponse<byte[]> getResponseByteArray(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        try {
            return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofByteArray(), proxy);
        }
        catch (IOException | InterruptedException ex) {
            throw new HttpClientException(ex.getMessage());
        }
    }

    public static HttpResponse<InputStream> getResponseInputStream(HttpRequest req, InetSocketAddress proxy) throws HttpClientException {
        try {
            return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofInputStream(), proxy);
        }
        catch (IOException | InterruptedException ex) {
            throw new HttpClientException(ex.getMessage());
        }
    }

    public static <R, T> HttpResponse<?> sendRequest(String url, HttpMethod method, int timeout, HttpHeaders headers, R requestBody, Class<T> responseType, InetSocketAddress proxy) throws URISyntaxException, HttpClientException {
        if (headers == null) {
            headers = HttpHeaders.NO_HEADERS;
        }
        HttpRequest request = HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headers.getHeaderList(), HttpClientUtil.getBodyPublisher(requestBody));
        try {
            return HttpClientUtil.getResponseRaw(request, HttpClientUtil.getBodyHandler(responseType), proxy);
        }
        catch (IOException | InterruptedException ex) {
            throw new HttpClientException(ex.getMessage());
        }
    }

    private static HttpRequest getRequestRaw(URI uri, HttpMethod method, int timeout, String[] headers, HttpRequest.BodyPublisher requestBody) {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri).method(method.name(), requestBody);
        if (headers.length > 0) {
            builder = builder.headers(headers);
        }
        return builder.timeout(Duration.ofSeconds(timeout)).build();
    }

    private static <T> HttpResponse<T> getResponseRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler, InetSocketAddress proxy) throws IOException, InterruptedException {
        if (ObjectUtil.isNull(proxy)) {
            return HttpClientUtil.getResponseRaw(req, responseBodyHandler);
        }
        return HttpClientUtil.getResponseProxyRaw(req, responseBodyHandler, proxy);
    }

    private static <T> HttpResponse<T> getResponseRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        return HttpClient.newHttpClient().send(req, responseBodyHandler);
    }

    private static <T> HttpResponse<T> getResponseProxyRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler, InetSocketAddress proxy) throws IOException, InterruptedException {
        return HttpClient.newBuilder().proxy(ProxySelector.of(proxy)).build().send(req, responseBodyHandler);
    }

    private static <T> HttpRequest.BodyPublisher getBodyPublisher(T requestBody) {
        if (ObjectUtil.isNull(requestBody)) {
            return HttpRequest.BodyPublishers.noBody();
        }
        Class<Object> type = requestBody.getClass();
        if (type.isAssignableFrom(CharSequence.class)) {
            return HttpRequest.BodyPublishers.ofString(requestBody.toString());
        }
        if (type.isAssignableFrom(InputStream.class)) {
            return HttpRequest.BodyPublishers.ofInputStream(() -> (InputStream)requestBody);
        }
        if (requestBody instanceof byte[]) {
            return HttpRequest.BodyPublishers.ofByteArray((byte[])requestBody);
        }
        throw new UnsupportedOperationException("Can NOT found supported type");
    }

    private static <T> HttpResponse.BodyHandler<?> getBodyHandler(Class<T> type) {
        if (type.isAssignableFrom(String.class)) {
            return HttpResponse.BodyHandlers.ofString();
        }
        if (type.isAssignableFrom(InputStream.class)) {
            return HttpResponse.BodyHandlers.ofInputStream();
        }
        return HttpResponse.BodyHandlers.ofByteArray();
    }
}

