/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class HttpHeaders {
    public static final HttpHeaders NO_HEADERS = new HttpHeaders();
    private final LinkedHashMap<String, ArrayList<String>> headers = new LinkedHashMap();
    private final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final char HTTP_HEADER_VALUE_SEPARTOR = ';';

    private HttpHeaders() {
    }

    public static HttpHeaders setHeader(String name, String ... values) {
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader(name, values);
        return headers;
    }

    public void setHeaders(String name, String ... values) {
        this.headers.put(name, new ArrayList<String>(List.of(values)));
    }

    public void addHeader(String name, String ... values) {
        if (this.headers.containsKey(name)) {
            ArrayList<String> valueOld = this.headers.get(name);
            ArrayList valueNew = (ArrayList)List.of(values);
            for (String s : valueOld) {
                if (valueNew.contains(s)) continue;
                valueNew.add(s);
            }
            this.headers.put(name, valueNew);
        } else {
            this.setHeaders(name, values);
        }
    }

    public String[] getHeaderList() {
        return this.headers.isEmpty() ? this.EMPTY_STRING_ARRAY : this.headerHeadler(this.headers);
    }

    private String[] headerHeadler(LinkedHashMap<String, ArrayList<String>> headerMap) {
        ArrayList headerList = new ArrayList();
        headerMap.forEach((key, value) -> {
            headerList.add(key);
            headerList.add(this.valuesHeadler((ArrayList<String>)value));
        });
        return (String[])headerList.toArray(String[]::new);
    }

    private String valuesHeadler(ArrayList<String> valueList) {
        StringBuilder sb = new StringBuilder();
        valueList.forEach(e -> {
            sb.append((String)e);
            sb.append(';');
            sb.append(" ");
        });
        return sb.deleteCharAt(sb.lastIndexOf(";")).toString().stripTrailing();
    }
}

