/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils;

/**
 * Character Util
 *
 * @author Leonard Woo
 */
public class CharUtil {

  /**
   * NUL or '\0'
   */
  public static final Character NULL = 0x000;

  /**
   * HT or '\t'
   */
  public static final Character HORIZONTAL_TABULATION = 0x009;

  /**
   * LF or '\n'
   */
  public static final Character LINE_FEED = 0x00A;

  /**
   * VT or '\v'
   */
  public static final Character VERTICAL_TABULATION = 0x00B;

  /**
   * FF or '\f'
   */
  public static final Character FORM_FEED = 0x00C;

  /**
   * CR or '\r'
   */
  public static final Character CARRIAGE_RETURN = 0x00D;

}
