/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils;

import java.time.Clock;
import java.util.TimeZone;

/**
 * Environmental constant
 *
 * @author Leonard Woo
 */
public class Environment {

  /**
   * Get system line interval symbol
   */
  public static final String NEW_LINE = System.lineSeparator();

  /**
   * Get Java/JDK version
   */
  public static final String JAVA_VERSION = System.getProperty("java.version");

  /**
   * Get system time zone
   */
  public static final TimeZone SYSTEM_ZONE = TimeZone.getDefault();

  /**
   * Get UTC zone
   */
  public static final Clock UTC_ZONE = Clock.systemUTC();

  /**
   * Digit char array
   */
  public static final char[] DIGIT = {'0', '1', '2', '3', '4', '5', '6',
      '7', '8', '9'};

  /**
   * Digit length
   */
  public static final int DIGIT_LENGTH = 10;

  /**
   * Hexadecimal char array
   */
  public static final char[] HEXADECIMAL = {'0', '1', '2', '3', '4', '5', '6',
      '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

  /**
   * Hexadecimal char array with upper word
   */
  public static final char[] HEXADECIMAL_UPPER = {'0', '1', '2', '3', '4', '5', '6',
      '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

  /**
   * Hexadecimal length
   */
  public static final int HEXADECIMAL_LENGTH = 16;

  /**
   * All uppercase letters char array
   */
  public static final char[] UPPERCASE = {'A', 'B', 'C', 'D', 'E', 'F', 'G',
      'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U',
      'V', 'W', 'X', 'Y', 'Z'};

  /**
   * All lowercase letters char array
   */
  public static final char[] LOWERCASE = {'a', 'b', 'c', 'd', 'e', 'f', 'g',
      'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u',
      'v', 'w', 'x', 'y', 'z'};

  /**
   * Alphabet length
   */
  public static final int ALPHABET_LENGTH = 26;

  /**
   * Config file parameter suffix
   */
  public static final String CONFIG_FILE_PARAMETER_SUFFIX = "configFile";

  /**
   * Config filename with yaml
   */
  public static final String CONFIG_FILENAME_YAML = "config.yaml";

  /**
   * Config filename with yml
   */
  public static final String CONFIG_FILENAME_YML = "config.yml";

  /**
   * Config filename with json
   */
  public static final String CONFIG_FILENAME_JSON = "config.json";

  /**
   * Config filename with toml
   */
  public static final String CONFIG_FILENAME_TOML = "config.toml";

  /**
   * Config filename with ini
   */
  public static final String CONFIG_FILENAME_INI = "config.ini";

}
