/*
 * Copyright 2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils;

/**
 * Type util
 *
 * @author Leonard Woo
 */
public class TypeUtil {

  /**
   * get Object type
   *
   * @param obj Object
   * @return object type class
   */
  public static Class<?> checkType(Object obj) {
    if (ObjectUtil.isNull(obj)) {
      return null;
    }
    if (obj instanceof Boolean) {
      return Boolean.TYPE;
    }
    if (obj instanceof Byte) {
      return Byte.TYPE;
    }
    if (obj instanceof Short) {
      return Short.TYPE;
    }
    if (obj instanceof Integer) {
      return Integer.TYPE;
    }
    if (obj instanceof Long) {
      return Long.TYPE;
    }
    if (obj instanceof Float) {
      return Float.TYPE;
    }
    if (obj instanceof Double) {
      return Double.TYPE;
    }
    if (obj instanceof Character) {
      return Character.TYPE;
    }
    throw new IllegalArgumentException("Not found type");
  }

  /**
   * get type boxing class
   *
   * @param type type class
   * @return boxing class
   */
  public static Class<?> warpper(Class<?> type) {
    if (ObjectUtil.isNull(type)) {
      return null;
    }
    if (type.isPrimitive()) {
      if (boolean.class == type) {
        return Boolean.class;
      }
      if (byte.class == type) {
        return Byte.class;
      }
      if (short.class == type) {
        return Short.class;
      }
      if (int.class == type) {
        return Integer.class;
      }
      if (long.class == type) {
        return Long.class;
      }
      if (float.class == type) {
        return Float.class;
      }
      if (double.class == type) {
        return Double.class;
      }
      if (char.class == type) {
        return Character.class;
      }
    }
    return type;
  }

}
