/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.seppiko.commons.utils.ObjectUtil;

public class StringUtil {
    public static CharSequence requireNonBlankElse(CharSequence str, CharSequence defaultStr) {
        return StringUtil.isEmpty(str) ? defaultStr : str;
    }

    public static boolean isEmpty(CharSequence str) {
        return ObjectUtil.isNull(str) || str.length() == 0;
    }

    public static boolean hasLength(CharSequence str) {
        return ObjectUtil.notNull(str) && str.length() > 0;
    }

    public static boolean hasText(CharSequence str) {
        return StringUtil.hasLength(str) && StringUtil.containsText(str);
    }

    public static boolean nonText(CharSequence str) {
        return ObjectUtil.notNull(str) && (str.length() == 0 || !StringUtil.containsText(str));
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isNumeric(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^-?\\d+(\\.\\d+)?$", input));
    }

    public static boolean isInteger(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^-?\\d+$", input));
    }

    public static boolean isDecimal(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^-?\\d+\\.\\d+$", input));
    }

    public static boolean isPunct(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^\\p{Punct}$", input));
    }

    public static boolean isSymbol(CharSequence input) {
        return Boolean.TRUE.equals(StringUtil.matches("^\\p{Symbol}$", input));
    }

    public static Boolean matches(String regex, CharSequence input) {
        try {
            return Objects.requireNonNull(StringUtil.getMatcher(regex, input)).matches();
        }
        catch (NullPointerException | PatternSyntaxException runtimeException) {
            return null;
        }
    }

    public static Matcher getMatcher(String regex, CharSequence input) {
        try {
            Pattern pattern = Pattern.compile(regex);
            return pattern.matcher(input);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return null;
        }
    }

    public static String transcoding(String data, Charset oldEncoding, Charset newEncoding) {
        return newEncoding.decode(oldEncoding.encode(data)).toString();
    }

    public static String fixedLength(String str, int length, char preChar) {
        StringBuilder sb = new StringBuilder();
        if (str.length() < length) {
            int preLength = length - str.length();
            sb.append(String.valueOf(preChar).repeat(preLength));
            sb.append(str);
        } else {
            sb.append(str.substring(str.length() - length));
        }
        return sb.toString();
    }

    public static String initialsUpperCase(String str) {
        if (str.length() > 1) {
            return str.substring(0, 1).toUpperCase() + str.substring(1);
        }
        return str.toUpperCase();
    }

    public static String replaceIndex(CharSequence data, int start, int end, CharSequence replacement) {
        StringBuilder sb = new StringBuilder();
        sb.append(data, 0, start);
        sb.append(replacement);
        sb.append(data, end, data.length());
        return sb.toString();
    }

    public static String convertToString(char[] src, int splitNum, String split) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length; i += splitNum) {
            for (int j = 0; j < splitNum; ++j) {
                sb.append(src[i + j]);
            }
            sb.append(split);
        }
        String dst = sb.toString();
        return dst.substring(0, dst.length() - split.length());
    }

    public static char[] convertToCharArray(String src, String split) {
        return src.replaceAll(split, "").toCharArray();
    }

    public static CharBuffer charsetDecode(Charset charset, byte[] data) {
        try {
            return charset.newDecoder().decode(ByteBuffer.wrap(data));
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }

    public static byte[] charsetEncode(Charset charset, CharBuffer data) {
        try {
            return charset.newEncoder().encode(data).array();
        }
        catch (CharacterCodingException characterCodingException) {
            return null;
        }
    }
}

