/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLSession;
import org.seppiko.commons.utils.Assert;
import org.seppiko.commons.utils.ObjectUtil;
import org.seppiko.commons.utils.http.HttpResponseException;

public class AsyncHttpClientUtil {
    public static HttpResponse<String> getAsyncResponseString(HttpRequest req, InetSocketAddress proxy) throws HttpResponseException, IllegalArgumentException {
        CompletableFuture resp = ObjectUtil.isNull(proxy) ? AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofString()) : AsyncHttpClientUtil.getAsyncResponseProxyRaw(req, HttpResponse.BodyHandlers.ofString(), proxy);
        return AsyncHttpClientUtil.httpResponse(resp);
    }

    public static HttpResponse<byte[]> getAsyncResponseByteArray(HttpRequest req, InetSocketAddress proxy) throws HttpResponseException, IllegalArgumentException {
        CompletableFuture resp = ObjectUtil.isNull(proxy) ? AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofByteArray()) : AsyncHttpClientUtil.getAsyncResponseProxyRaw(req, HttpResponse.BodyHandlers.ofByteArray(), proxy);
        return AsyncHttpClientUtil.httpResponse(resp);
    }

    public static HttpResponse<InputStream> getAsyncResponseInputStream(HttpRequest req, InetSocketAddress proxy) throws HttpResponseException, IllegalArgumentException {
        CompletableFuture resp = ObjectUtil.isNull(proxy) ? AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofInputStream()) : AsyncHttpClientUtil.getAsyncResponseProxyRaw(req, HttpResponse.BodyHandlers.ofInputStream(), proxy);
        return AsyncHttpClientUtil.httpResponse(resp);
    }

    private static <T> HttpResponse<T> httpResponse(final CompletableFuture<HttpResponse<T>> resp) throws HttpResponseException {
        try {
            return new HttpResponse<T>(){

                @Override
                public int statusCode() {
                    try {
                        return (Integer)((CompletableFuture)resp.thenApply(HttpResponse::statusCode)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Assert.sneakyThrow(e);
                    }
                }

                @Override
                public HttpRequest request() {
                    try {
                        return (HttpRequest)((CompletableFuture)resp.thenApply(HttpResponse::request)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Assert.sneakyThrow(e);
                    }
                }

                @Override
                public Optional<HttpResponse<T>> previousResponse() {
                    try {
                        return (Optional)((CompletableFuture)resp.thenApply(HttpResponse::previousResponse)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Assert.sneakyThrow(e);
                    }
                }

                @Override
                public HttpHeaders headers() {
                    try {
                        return (HttpHeaders)((CompletableFuture)resp.thenApply(HttpResponse::headers)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Assert.sneakyThrow(e);
                    }
                }

                @Override
                public T body() {
                    try {
                        return ((CompletableFuture)resp.thenApply(HttpResponse::body)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Assert.sneakyThrow(e);
                    }
                }

                @Override
                public Optional<SSLSession> sslSession() {
                    try {
                        return (Optional)((CompletableFuture)resp.thenApply(HttpResponse::sslSession)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Assert.sneakyThrow(e);
                    }
                }

                @Override
                public URI uri() {
                    try {
                        return (URI)((CompletableFuture)resp.thenApply(HttpResponse::uri)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Assert.sneakyThrow(e);
                    }
                }

                @Override
                public HttpClient.Version version() {
                    try {
                        return (HttpClient.Version)((Object)((CompletableFuture)resp.thenApply(HttpResponse::version)).get());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw Assert.sneakyThrow(e);
                    }
                }
            };
        }
        catch (RuntimeException ex) {
            throw new HttpResponseException(ex);
        }
    }

    private static <T> CompletableFuture<HttpResponse<T>> getAsyncResponseRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler) throws IllegalArgumentException {
        return HttpClient.newHttpClient().sendAsync(req, responseBodyHandler);
    }

    private static <T> CompletableFuture<HttpResponse<T>> getAsyncResponseProxyRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler, InetSocketAddress proxy) throws IllegalArgumentException {
        return HttpClient.newBuilder().proxy(ProxySelector.of(proxy)).build().sendAsync(req, responseBodyHandler);
    }
}

