/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import org.seppiko.commons.utils.StringUtil;

public class Assert {
    private Assert() {
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isFalse(boolean expression, String message) {
        if (expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasLength(String text, String message) {
        if (StringUtil.isNullOrEmpty(text)) {
            throw new NullPointerException(message);
        }
    }

    public static void hasText(String text, String message) {
        if (StringUtil.nonText(text)) {
            throw new NullPointerException(message);
        }
    }

    public static RuntimeException sneakyThrow(Throwable t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return (RuntimeException)Assert.sneakyThrow0(t);
    }

    private static <T extends Throwable> T sneakyThrow0(Throwable t) throws T {
        throw t;
    }
}

