/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.seppiko.commons.utils.Environment;
import org.seppiko.commons.utils.NumberUtil;

public class CharUtil
implements Serializable {
    private static final long serialVersionUID = 7063635226739813394L;
    public static final Character NULL = Character.valueOf('\u0000');
    public static final Character HORIZONTAL_TABULATION = Character.valueOf('\t');
    public static final Character LINE_FEED = Character.valueOf('\n');
    public static final Character VERTICAL_TABULATION = Character.valueOf('\u000b');
    public static final Character FORM_FEED = Character.valueOf('\f');
    public static final Character CARRIAGE_RETURN = Character.valueOf('\r');
    public static final String CRLF = String.valueOf(new char[]{CARRIAGE_RETURN.charValue(), LINE_FEED.charValue()});
    public static final char[] DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char DIGIT_ZERO = DIGIT[0];
    public static final char DIGIT_ONE = DIGIT[1];
    public static final char DIGIT_NINE = DIGIT[9];
    public static final char[] UPPERCASE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char UPPERCASE_A = UPPERCASE[0];
    public static final char UPPERCASE_Z = UPPERCASE[25];
    public static final char[] LOWERCASE = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char LOWERCASE_A = LOWERCASE[0];
    public static final char LOWERCASE_Z = LOWERCASE[25];
    public static final Character SPACE = Character.valueOf(' ');
    public static final Character EXCLAMATION_MARK = Character.valueOf('!');
    public static final Character QUOTATION_MARK = Character.valueOf('\"');
    public static final Character NUMBER_SIGN = Character.valueOf('#');
    public static final Character DOLLAR_SIGN = Character.valueOf('$');
    public static final Character PERCENT_SIGN = Character.valueOf('%');
    public static final Character AMPERSAND = Character.valueOf('&');
    public static final Character APOSTROPHE = Character.valueOf('\'');
    public static final Character LEFT_PARENTHESIS = Character.valueOf('(');
    public static final Character RIGHT_PARENTHESIS = Character.valueOf(')');
    public static final Character ASTERISK = Character.valueOf('*');
    public static final Character PLUS = Character.valueOf('+');
    public static final Character COMMA = Character.valueOf(',');
    public static final Character HYPHEN_MINUS = Character.valueOf('-');
    public static final Character FULL_STOP = Character.valueOf('.');
    public static final Character SOLIDUS = Character.valueOf('/');
    public static final Character COLON = Character.valueOf(':');
    public static final Character SEMICOLON = Character.valueOf(';');
    public static final Character LESS_THAN_SIGN = Character.valueOf('<');
    public static final Character EQUALS_SIGN = Character.valueOf('=');
    public static final Character GREATER_THAN_SIGN = Character.valueOf('>');
    public static final Character QUESTION_MARK = Character.valueOf('?');
    public static final Character COMMERCIAL_AT = Character.valueOf('@');
    public static final Character LEFT_SQUARE_BRACKET = Character.valueOf('[');
    public static final Character REVERSE_SOLIDUS = Character.valueOf('\\');
    public static final Character RIGHT_SQUARE_BRACKET = Character.valueOf(']');
    public static final Character CIRCUMFLEX_ACCENT = Character.valueOf('^');
    public static final Character LOW_LINE = Character.valueOf('_');
    public static final Character GRAVE_ACCENT = Character.valueOf('`');
    public static final Character LEFT_CURLY_BRACKET = Character.valueOf('{');
    public static final Character VERTICAL_LINE = Character.valueOf('|');
    public static final Character RIGHT_CURLY_BRACKET = Character.valueOf('}');
    public static final Character TILDE = Character.valueOf('~');
    public static final char[] PUNCTUATION = new char[]{EXCLAMATION_MARK.charValue(), QUOTATION_MARK.charValue(), NUMBER_SIGN.charValue(), DOLLAR_SIGN.charValue(), PERCENT_SIGN.charValue(), AMPERSAND.charValue(), APOSTROPHE.charValue(), LEFT_PARENTHESIS.charValue(), RIGHT_PARENTHESIS.charValue(), ASTERISK.charValue(), PLUS.charValue(), COMMA.charValue(), HYPHEN_MINUS.charValue(), FULL_STOP.charValue(), SOLIDUS.charValue(), COLON.charValue(), SEMICOLON.charValue(), LESS_THAN_SIGN.charValue(), EQUALS_SIGN.charValue(), GREATER_THAN_SIGN.charValue(), QUESTION_MARK.charValue(), COMMERCIAL_AT.charValue(), LEFT_SQUARE_BRACKET.charValue(), REVERSE_SOLIDUS.charValue(), RIGHT_SQUARE_BRACKET.charValue(), CIRCUMFLEX_ACCENT.charValue(), LOW_LINE.charValue(), GRAVE_ACCENT.charValue(), LEFT_CURLY_BRACKET.charValue(), VERTICAL_LINE.charValue(), RIGHT_CURLY_BRACKET.charValue(), TILDE.charValue()};
    public static final char[] FULLWIDTH_DIGIT = new char[]{'\uff10', '\uff11', '\uff12', '\uff13', '\uff14', '\uff15', '\uff16', '\uff17', '\uff18', '\uff19'};
    public static final char FULLWIDTH_DIGIT_ZERO = FULLWIDTH_DIGIT[0];
    public static final char FULLWIDTH_DIGIT_ONE = FULLWIDTH_DIGIT[1];
    public static final char FULLWIDTH_DIGIT_NINE = FULLWIDTH_DIGIT[9];
    public static final char[] FULLWIDTH_UPPERCASE = new char[]{'\uff21', '\uff22', '\uff23', '\uff24', '\uff25', '\uff26', '\uff27', '\uff28', '\uff29', '\uff2a', '\uff2b', '\uff2c', '\uff2d', '\uff2e', '\uff2f', '\uff30', '\uff31', '\uff32', '\uff33', '\uff34', '\uff35', '\uff36', '\uff37', '\uff38', '\uff39', '\uff3a'};
    public static final char FULLWIDTH_UPPERCASE_A = FULLWIDTH_UPPERCASE[0];
    public static final char FULLWIDTH_UPPERCASE_Z = FULLWIDTH_UPPERCASE[25];
    public static final char[] FULLWIDTH_LOWERCASE = new char[]{'\uff41', '\uff42', '\uff43', '\uff44', '\uff45', '\uff46', '\uff47', '\uff48', '\uff49', '\uff4a', '\uff4b', '\uff4c', '\uff4d', '\uff4e', '\uff4f', '\uff50', '\uff51', '\uff52', '\uff53', '\uff54', '\uff55', '\uff56', '\uff57', '\uff58', '\uff59', '\uff5a'};
    public static final char FULLWIDTH_LOWERCASE_A = FULLWIDTH_LOWERCASE[0];
    public static final char FULLWIDTH_LOWERCASE_Z = FULLWIDTH_LOWERCASE[25];
    public static final Character FULLWIDTH_EXCLAMATION_MARK = Character.valueOf('\uff01');
    public static final Character FULLWIDTH_QUOTATION_MARK = Character.valueOf('\uff02');
    public static final Character FULLWIDTH_NUMBER_SIGN = Character.valueOf('\uff03');
    public static final Character FULLWIDTH_DOLLAR_SIGN = Character.valueOf('\uff04');
    public static final Character FULLWIDTH_PERCENT_SIGN = Character.valueOf('\uff05');
    public static final Character FULLWIDTH_AMPERSAND = Character.valueOf('\uff06');
    public static final Character FULLWIDTH_APOSTROPHE = Character.valueOf('\uff07');
    public static final Character FULLWIDTH_LEFT_PARENTHESIS = Character.valueOf('\uff08');
    public static final Character FULLWIDTH_RIGHT_PARENTHESIS = Character.valueOf('\uff09');
    public static final Character FULLWIDTH_ASTERISK = Character.valueOf('\uff0a');
    public static final Character FULLWIDTH_PLUS = Character.valueOf('\uff0b');
    public static final Character FULLWIDTH_COMMA = Character.valueOf('\uff0c');
    public static final Character FULLWIDTH_HYPHEN_MINUS = Character.valueOf('\uff0d');
    public static final Character FULLWIDTH_FULL_STOP = Character.valueOf('\uff0e');
    public static final Character FULLWIDTH_SOLIDUS = Character.valueOf('\uff0f');
    public static final Character FULLWIDTH_COLON = Character.valueOf('\uff1a');
    public static final Character FULLWIDTH_SEMICOLON = Character.valueOf('\uff1b');
    public static final Character FULLWIDTH_LESS_THAN_SIGN = Character.valueOf('\uff1c');
    public static final Character FULLWIDTH_EQUALS_SIGN = Character.valueOf('\uff1d');
    public static final Character FULLWIDTH_GREATER_THAN_SIGN = Character.valueOf('\uff1e');
    public static final Character FULLWIDTH_QUESTION_MARK = Character.valueOf('\uff1f');
    public static final Character FULLWIDTH_COMMERCIAL_AT = Character.valueOf('\uff20');
    public static final Character FULLWIDTH_LEFT_SQUARE_BRACKET = Character.valueOf('\uff3b');
    public static final Character FULLWIDTH_REVERSE_SOLIDUS = Character.valueOf('\uff3c');
    public static final Character FULLWIDTH_RIGHT_SQUARE_BRACKET = Character.valueOf('\uff3d');
    public static final Character FULLWIDTH_CIRCUMFLEX_ACCENT = Character.valueOf('\uff3e');
    public static final Character FULLWIDTH_LOW_LINE = Character.valueOf('\uff3f');
    public static final Character FULLWIDTH_GRAVE_ACCENT = Character.valueOf('\uff40');
    public static final Character FULLWIDTH_LEFT_CURLY_BRACKET = Character.valueOf('\uff5b');
    public static final Character FULLWIDTH_VERTICAL_LINE = Character.valueOf('\uff5c');
    public static final Character FULLWIDTH_RIGHT_CURLY_BRACKET = Character.valueOf('\uff5d');
    public static final Character FULLWIDTH_TILDE = Character.valueOf('\uff5e');
    public static final char[] FULLWIDTH_PUNCTUATION = new char[]{FULLWIDTH_EXCLAMATION_MARK.charValue(), FULLWIDTH_QUOTATION_MARK.charValue(), FULLWIDTH_NUMBER_SIGN.charValue(), FULLWIDTH_DOLLAR_SIGN.charValue(), FULLWIDTH_PERCENT_SIGN.charValue(), FULLWIDTH_AMPERSAND.charValue(), FULLWIDTH_APOSTROPHE.charValue(), FULLWIDTH_LEFT_PARENTHESIS.charValue(), FULLWIDTH_RIGHT_PARENTHESIS.charValue(), FULLWIDTH_ASTERISK.charValue(), FULLWIDTH_PLUS.charValue(), FULLWIDTH_COMMA.charValue(), FULLWIDTH_HYPHEN_MINUS.charValue(), FULLWIDTH_FULL_STOP.charValue(), FULLWIDTH_SOLIDUS.charValue(), FULLWIDTH_COLON.charValue(), FULLWIDTH_SEMICOLON.charValue(), FULLWIDTH_LESS_THAN_SIGN.charValue(), FULLWIDTH_EQUALS_SIGN.charValue(), FULLWIDTH_GREATER_THAN_SIGN.charValue(), FULLWIDTH_QUESTION_MARK.charValue(), FULLWIDTH_COMMERCIAL_AT.charValue(), FULLWIDTH_LEFT_SQUARE_BRACKET.charValue(), FULLWIDTH_REVERSE_SOLIDUS.charValue(), FULLWIDTH_RIGHT_SQUARE_BRACKET.charValue(), FULLWIDTH_CIRCUMFLEX_ACCENT.charValue(), FULLWIDTH_LOW_LINE.charValue(), FULLWIDTH_GRAVE_ACCENT.charValue(), FULLWIDTH_LEFT_CURLY_BRACKET.charValue(), FULLWIDTH_VERTICAL_LINE.charValue(), FULLWIDTH_RIGHT_CURLY_BRACKET.charValue(), FULLWIDTH_TILDE.charValue()};

    private CharUtil() {
    }

    public static CharBuffer charsetDecode(Charset charset, byte[] data) {
        try {
            return charset.decode(ByteBuffer.wrap(data));
        }
        catch (RuntimeException runtimeException) {
            return CharBuffer.allocate(0);
        }
    }

    public static byte[] charsetEncode(Charset charset, CharBuffer data) {
        try {
            return charset.encode(data).array();
        }
        catch (RuntimeException runtimeException) {
            return Environment.EMPTY_BYTE_ARRAY;
        }
    }

    public static char[] convertBytes(byte[] data) {
        char[] hexs = new char[data.length * 2];
        int i = 0;
        int j = 0;
        while (i < data.length) {
            char[] hex = Integer.toHexString(data[i] & 0xFF).toCharArray();
            if (hex.length == 1) {
                hexs[j] = DIGIT_ZERO;
                hexs[j + 1] = hex[0];
            } else {
                hexs[j] = hex[0];
                hexs[j + 1] = hex[1];
            }
            ++i;
            j += 2;
        }
        return hexs;
    }

    public static boolean isDigit(char ch) {
        return NumberUtil.between(ch, DIGIT_ZERO, DIGIT_NINE) || NumberUtil.between(ch, FULLWIDTH_DIGIT_ZERO, FULLWIDTH_DIGIT_NINE);
    }

    public static boolean isFullStop(char ch) {
        return ch == FULL_STOP.charValue() || ch == FULLWIDTH_FULL_STOP.charValue();
    }

    public static int findIndex(char c, char[] chars) {
        if (NumberUtil.between(c, chars[0], chars[chars.length - 1])) {
            for (int i = 0; i < chars.length; ++i) {
                if (c != chars[i]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int findIndex(char c, CharSequence cs) {
        if (NumberUtil.between(c, cs.charAt(0), cs.charAt(cs.length() - 1))) {
            for (int i = 0; i < cs.length(); ++i) {
                if (c != cs.charAt(i)) continue;
                return i;
            }
        }
        return -1;
    }
}

