/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DatetimeUtil
implements Serializable {
    private static final long serialVersionUID = -3239240029308812973L;
    public static final Clock SYSTEM_ZONE = Clock.systemDefaultZone();
    public static final Clock UTC_ZONE = Clock.systemUTC();
    public static final Locale DEFAULT_LOCALE = Locale.getDefault(Locale.Category.FORMAT);
    public static final DateTimeFormatter DATABASE_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    public static final DateTimeFormatter RFC_3339_OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendFraction(ChronoField.NANO_OF_SECOND, 0, 4, true).appendLiteral('Z').parseLenient().appendOffset("+HH:MM", "").parseStrict().toFormatter();
    public static final DateTimeFormatter BASIC_ISO_DATE = DateTimeFormatter.BASIC_ISO_DATE;
    public static final DateTimeFormatter BASIC_ISO_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).toFormatter();
    public static final DateTimeFormatter BASIC_ISO_OFFSET_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.HOUR_OF_DAY, 2).appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendValue(ChronoField.SECOND_OF_MINUTE, 2).parseLenient().appendOffset("+HH:MM", "Z").parseStrict().toFormatter();

    private DatetimeUtil() {
    }

    public static String format(String pattern, TemporalAccessor temporal) {
        return DatetimeUtil.format(pattern, DEFAULT_LOCALE, temporal);
    }

    public static String format(String pattern, Locale locale, TemporalAccessor temporal) {
        return DateTimeFormatter.ofPattern(pattern, locale).format(temporal);
    }

    public static ZonedDateTime parse(String pattern, String timestamp) {
        return DatetimeUtil.parse(pattern, DEFAULT_LOCALE, timestamp);
    }

    public static ZonedDateTime parse(String pattern, Locale locale, String timestamp) {
        return ZonedDateTime.parse(timestamp, DateTimeFormatter.ofPattern(pattern, locale));
    }

    public static long toEpochSecond(TemporalAccessor temporal) {
        return Instant.from(temporal).getEpochSecond();
    }

    public static long toEpochMilliSecond(TemporalAccessor temporal) {
        return Instant.from(temporal).toEpochMilli();
    }

    public static ZonedDateTime parseEpochSecond(long epoch, ZoneId zoneId) {
        return Instant.ofEpochSecond(epoch).atZone(zoneId);
    }

    public static ZonedDateTime parseEpochMilliSecond(long milli, ZoneId zoneId) {
        return Instant.ofEpochMilli(milli).atZone(zoneId);
    }

    public static long now() {
        return Instant.now().toEpochMilli();
    }

    public static long now(ZoneId zoneId) {
        return Instant.now(Clock.system(zoneId)).toEpochMilli();
    }

    public static LocalDate today() {
        return LocalDate.now();
    }

    public static LocalDate today(ZoneId zoneId) {
        return LocalDate.now(zoneId);
    }

    public static YearMonth getYearMonth(LocalDate date) {
        return YearMonth.from(date);
    }

    public static MonthDay getMonthDay(LocalDate date) {
        return MonthDay.from(date);
    }

    public static Date toDate(LocalDateTime datetime, ZoneId zoneId) {
        return Date.from(datetime.atZone(zoneId).toInstant());
    }

    public static LocalDateTime fromDate(Date datetime, ZoneId zoneId) {
        return LocalDateTime.ofInstant(datetime.toInstant(), zoneId);
    }

    public static Calendar toCalendar(LocalDateTime dateTime, ZoneId zoneId) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone(zoneId));
        calendar.setTimeInMillis(Instant.from(dateTime).toEpochMilli());
        return calendar;
    }

    public static LocalDateTime fromCalendar(Calendar calendar, ZoneId zoneId) {
        return LocalDateTime.ofInstant(calendar.toInstant(), zoneId);
    }
}

