/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.StringUtil;

public class NumberUtil {
    public static final int LATIN_DIGITS = 1;
    public static final int FULLWIDTH_DIGITS = 4;

    private NumberUtil() {
    }

    public static boolean between(byte num, byte min, byte max) {
        return num >= min && num <= max;
    }

    public static boolean between(short num, short min, short max) {
        return num >= min && num <= max;
    }

    public static boolean between(int num, int min, int max) {
        return num >= min && num <= max;
    }

    public static boolean between(long num, long min, long max) {
        return num >= min && num <= max;
    }

    public static boolean between(float num, float min, float max) {
        return num >= min && num <= max;
    }

    public static boolean between(double num, double min, double max) {
        return num >= min && num <= max;
    }

    public static boolean between(char num, char min, char max) {
        return num >= min && num <= max;
    }

    public static boolean between(BigDecimal num, BigDecimal min, BigDecimal max) {
        return num.compareTo(min) >= 0 && num.compareTo(max) <= 0;
    }

    public static boolean between(BigInteger num, BigInteger min, BigInteger max) {
        return num.compareTo(min) >= 0 && num.compareTo(max) <= 0;
    }

    public static String format(String precisionPattern, double number) {
        return new DecimalFormat(precisionPattern).format(number);
    }

    public static int[] toUnsignedIntArray(byte[] src) {
        int[] dst = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Byte.toUnsignedInt(src[i]);
        }
        return dst;
    }

    public static int[] toUnsignedShortArray(short[] src) {
        int[] dst = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Short.toUnsignedInt(src[i]);
        }
        return dst;
    }

    public static long[] toUnsignedLongArray(int[] src) {
        long[] dst = new long[src.length];
        for (int i = 0; i < src.length; ++i) {
            dst[i] = Integer.toUnsignedLong(src[i]);
        }
        return dst;
    }

    public static String convert(CharSequence input, int outType) throws IllegalArgumentException {
        if (!StringUtil.isNumeric(input)) {
            throw new IllegalArgumentException("input is not number");
        }
        BigDecimal digit = new BigDecimal(NumberUtil.toHalfWidthWithoutNumeric(input));
        if (outType == 1) {
            return digit.toString();
        }
        if (outType == 4) {
            return StringUtil.toFullWidth(digit.toString());
        }
        throw new IllegalArgumentException("outType is wrong");
    }

    protected static String toHalfWidthWithoutNumeric(CharSequence input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (NumberUtil.between(c, CharUtil.FULLWIDTH_DIGIT_ZERO, CharUtil.FULLWIDTH_DIGIT_NINE)) {
                sb.append(c);
                continue;
            }
            sb.append(StringUtil.toHalfWidth(String.valueOf(c)));
        }
        return sb.toString();
    }
}

