/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.Environment;
import org.seppiko.commons.utils.NumberUtil;
import org.seppiko.commons.utils.RegexUtil;

public class StringUtil {
    protected static final Integer BETWEEN = CharUtil.FULLWIDTH_EXCLAMATION_MARK.charValue() - CharUtil.EXCLAMATION_MARK.charValue();

    private StringUtil() {
    }

    public static CharSequence requireNonBlankElse(CharSequence value, CharSequence defaultValue) {
        return StringUtil.isNullOrEmpty(value) ? defaultValue : value;
    }

    public static boolean isNullOrEmpty(CharSequence value) {
        return Objects.isNull(value) || value.isEmpty();
    }

    public static boolean hasLength(CharSequence input) {
        return Objects.nonNull(input) && input.length() > 0;
    }

    public static boolean hasText(CharSequence input) {
        return StringUtil.hasLength(input) && StringUtil.containsText(input);
    }

    public static boolean nonText(CharSequence input) {
        return Objects.nonNull(input) && (input.isEmpty() || !StringUtil.containsText(input));
    }

    private static boolean containsText(CharSequence input) {
        for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            if (Character.isWhitespace(ch) && Character.isISOControl(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isUppercase(CharSequence input) {
        return RegexUtil.matches("^[\\p{Upper}\uff21-\uff3a]+$", input);
    }

    public static boolean isLowercase(CharSequence input) {
        return RegexUtil.matches("^[\\p{Lower}\uff41-\uff5a]+$", input);
    }

    public static boolean isNumeric(CharSequence input) {
        return RegexUtil.matches("^[-\uff0d+\uff0b]?[\\d\uff10-\uff19]+([\\.\uff0e]{1}[\\d\uff10-\uff19]+)?$", input);
    }

    public static boolean isInteger(CharSequence input) {
        return RegexUtil.matches("^[-\uff0d+\uff0b]?[\\d\uff10-\uff19]+$", input);
    }

    public static boolean isDecimal(CharSequence input) {
        return RegexUtil.matches("^[-\uff0d+\uff0b]?[\\d\uff10-\uff19]+[\\.\uff0e]{1}[\\d\uff10-\uff19]+$", input);
    }

    public static boolean isPunctuation(CharSequence input) {
        return RegexUtil.matches("^[\\p{Punct}\uff01\uff02\uff03\uff04\uff05\uff06\uff07\uff08\uff09\uff0a\uff0b\uff0c\uff0d\uff0e\uff0f\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff3b\uff3c\uff3d\uff3e\uff3f\uff40\uff5b\uff5c\uff5d]+$", input);
    }

    public static String transcoding(CharSequence data, Charset oldEncoding, Charset newEncoding) throws NullPointerException {
        byte[] oldData = CharUtil.charsetEncode(oldEncoding, CharBuffer.wrap(data));
        if (oldData == Environment.EMPTY_BYTE_ARRAY) {
            throw new NullPointerException("old encode exception");
        }
        CharBuffer cb = CharUtil.charsetDecode(newEncoding, oldData);
        if (cb.capacity() == 0) {
            throw new NullPointerException("new decode exception");
        }
        return cb.toString();
    }

    public static String fixedLength(String str, int length, char preChar) {
        StringBuilder sb = new StringBuilder();
        if (str.length() < length) {
            int preLength = length - str.length();
            sb.append(String.valueOf(preChar).repeat(preLength));
            sb.append(str);
        } else {
            sb.append(str.substring(str.length() - length));
        }
        return sb.toString();
    }

    public static String toFirstUpperCase(String input) {
        String s = String.valueOf(Character.toUpperCase(input.charAt(0)));
        if (input.length() > 1) {
            return s + input.subSequence(1, input.length());
        }
        return s;
    }

    public static String replaceBetween(CharSequence data, int start, int end, CharSequence replacement) {
        StringBuilder sb = new StringBuilder();
        sb.append(data, 0, start);
        sb.append(replacement);
        sb.append(data, end, data.length());
        return sb.toString();
    }

    public static String convertJoinerString(String delimiter, String ... strs) {
        StringJoiner sj = new StringJoiner(delimiter);
        for (String str : strs) {
            if (!StringUtil.hasLength(str)) continue;
            sj.add(str);
        }
        return sj.toString();
    }

    public static String convertToString(CharSequence input, int splitNum, String split) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); i += splitNum) {
            for (int j = 0; j < splitNum; ++j) {
                sb.append(input.charAt(i + j));
            }
            sb.append(split);
        }
        String dst = sb.toString();
        return dst.substring(0, dst.length() - split.length());
    }

    public static char[] convertToCharArray(String src, String separator) throws NullPointerException {
        Objects.requireNonNull(src, "src must not be null.");
        Objects.requireNonNull(separator, "separator must not be null.");
        Matcher m = RegexUtil.getMatcher(separator, src);
        Objects.requireNonNull(m, "split matcher failed");
        if (m.find()) {
            return m.replaceAll("").toCharArray();
        }
        return src.toCharArray();
    }

    public static Map<String, String> splitToMap(String input, String nodeSeparator, String pairSeparator) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (!input.isEmpty()) {
            String[] parts;
            for (String part : parts = RegexUtil.split(nodeSeparator, input)) {
                String[] pair = RegexUtil.split(pairSeparator, part);
                map.put(pair[0], pair[1]);
            }
        }
        return map;
    }

    public static String toFullWidth(CharSequence src) {
        StringBuilder sb = new StringBuilder(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (NumberUtil.between(c, CharUtil.EXCLAMATION_MARK.charValue(), CharUtil.TILDE.charValue())) {
                sb.append((char)(c + BETWEEN));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toHalfWidth(CharSequence src) {
        StringBuilder sb = new StringBuilder(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char c = src.charAt(i);
            if (NumberUtil.between(c, CharUtil.FULLWIDTH_EXCLAMATION_MARK.charValue(), CharUtil.FULLWIDTH_TILDE.charValue())) {
                sb.append((char)(c - BETWEEN));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String unicodeDecode(String src) {
        if (StringUtil.isNullOrEmpty(src)) {
            return "";
        }
        Matcher m = RegexUtil.getMatcher("(\\\\u(\\p{XDigit}{4}))", src);
        while (m.find()) {
            String group = m.group(2);
            char ch = (char)Integer.parseInt(group, 16);
            String group1 = m.group(1);
            src = src.replace(group1, String.valueOf(ch));
        }
        return src;
    }

    public static String unicodeEncode(String src) {
        if (StringUtil.isNullOrEmpty(src)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            if (NumberUtil.between(ch, CharUtil.SPACE.charValue(), CharUtil.TILDE.charValue())) {
                sb.append(ch);
                continue;
            }
            sb.append("\\u");
            String hex = Integer.toHexString(ch & 0xFFFF).toUpperCase();
            sb.append(StringUtil.fixedLength(hex, 4, CharUtil.DIGIT_ONE));
        }
        return sb.toString();
    }
}

