/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.io.Serializable;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.codec.BaseNCodec;
import org.seppiko.commons.utils.codec.HexUtil;

public class Base16
implements BaseNCodec,
Serializable {
    private static final long serialVersionUID = -3844227952413070095L;
    private static final int BITS_PER_ENCODED_BYTE = 4;
    private static final char[] LOWER_CASE_TABLE = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'};
    private static final char[] UPPER_CASE_TABLE = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P'};
    private static final byte[] CASE_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
    public static final Base16 RFC4648 = new Base16(HexUtil.HEXADECIMAL, HexUtil.HEXADECIMAL_DECODE_TABLE);
    public static final Base16 RFC4648_UPPER = new Base16(HexUtil.HEXADECIMAL_UPPER, HexUtil.HEXADECIMAL_DECODE_TABLE);
    public static final Base16 BASE16_UPPERCASE = new Base16(UPPER_CASE_TABLE, CASE_DECODE_TABLE);
    public static final Base16 BASE16_CASE = new Base16(LOWER_CASE_TABLE, CASE_DECODE_TABLE);
    private final char[] encodeTable;
    private final byte[] decodeTable;

    private Base16(char[] encodeTable, byte[] decodeTable) {
        this.encodeTable = encodeTable;
        this.decodeTable = decodeTable;
    }

    @Override
    public String encodeString(byte[] data) {
        return new String(this.encode0(data, this.encodeTable));
    }

    private char[] encode0(byte[] data, char[] hexChar) {
        char[] hex = new char[data.length * 2];
        int j = 0;
        for (int i = 0; i < data.length; ++i) {
            byte b = data[i];
            hex[j++] = hexChar[(int)((long)(b >> 4) & 0xFL)];
            hex[j++] = hexChar[(int)((long)b & 0xFL)];
        }
        return hex;
    }

    @Override
    public byte[] decode(String str) throws IllegalArgumentException, NullPointerException {
        if (StringUtil.isNullOrEmpty(str)) {
            throw new NullPointerException();
        }
        char[] data = str.toCharArray();
        byte[] hex = new byte[data.length / 2];
        int j = 0;
        for (int i = 0; i < hex.length; ++i) {
            int f = this.decodeTable[data[j++]] << 4;
            hex[i] = (byte)(f |= this.decodeTable[data[j++]]);
        }
        return hex;
    }
}

