/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.io.Serializable;
import java.util.Objects;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.codec.BaseNCodec;

public class Base32
implements BaseNCodec,
Serializable {
    private static final long serialVersionUID = -5230113688025284966L;
    private static final byte[] RFC4648_ENCODE_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 50, 51, 52, 53, 54, 55};
    private static final byte[] RFC4648_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final byte[] RFC4648_HEX_ENCODE_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86};
    private static final byte[] RFC4648_HEX_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private static final byte[] ZBASE32_ENCODE_TABLE = new byte[]{121, 98, 110, 100, 114, 102, 103, 56, 101, 106, 107, 109, 99, 112, 113, 120, 111, 116, 49, 117, 119, 105, 115, 122, 97, 51, 52, 53, 104, 55, 54, 57};
    private static final byte[] ZBASE32_DECODE_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 18, -1, 25, 26, 27, 30, 29, 7, 31, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
    public static final Base32 RFC4648 = new Base32(RFC4648_ENCODE_TABLE, RFC4648_DECODE_TABLE);
    public static final Base32 RFC4648_HEX = new Base32(RFC4648_HEX_ENCODE_TABLE, RFC4648_HEX_DECODE_TABLE);
    public static final Base32 ZBASE32 = new Base32(ZBASE32_ENCODE_TABLE, ZBASE32_DECODE_TABLE);
    private final byte[] encodeTable;
    private final byte[] decodeTable;
    private final char padding;

    private Base32(byte[] encodeTable, byte[] decodeTable) {
        if (encodeTable.length != 32) {
            throw new IllegalArgumentException("base32 alphabet must have 32 chars.");
        }
        this.encodeTable = encodeTable;
        this.decodeTable = decodeTable;
        this.padding = CharUtil.EQUALS_SIGN.charValue();
    }

    @Override
    public String encodeString(byte[] source) {
        if (null == source) {
            throw new NullPointerException("source must be not null.");
        }
        int maxEncodeLength = (source.length + 7) * 8 / 5;
        StringBuilder result = new StringBuilder(maxEncodeLength);
        int idx = 0;
        int i = 0;
        while (i < source.length) {
            int digit;
            int currByte;
            int b = source[i];
            int n = currByte = b >= 0 ? b : b + 256;
            if (idx > 3) {
                int next;
                int nextByte = i + 1 < source.length ? ((next = source[i + 1]) >= 0 ? next : next + 256) : 0;
                digit = (int)((long)currByte & 255L >> idx);
                idx = (idx + 5) % 8;
                digit <<= idx;
                digit |= nextByte >> 8 - idx;
                ++i;
            } else {
                digit = (int)((long)(currByte >> 8 - (idx + 5)) & 0x1FL);
                if ((idx = (idx + 5) % 8) == 0) {
                    ++i;
                }
            }
            result.append((char)this.encodeTable[digit]);
        }
        while (result.length() % 8 != 0) {
            result.append(this.padding);
        }
        return result.toString();
    }

    @Override
    public byte[] decode(String str) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(str, "input string must be not null.");
        if (str.length() % 8 != 0) {
            throw new IllegalArgumentException("input string length must be divisible by 8.");
        }
        int len = str.endsWith(String.valueOf(this.padding)) ? str.indexOf(this.padding) * 5 / 8 : str.length() * 5 / 8;
        byte[] result = new byte[len];
        int idx = 0;
        int offset = 0;
        for (int i = 0; i < str.length(); ++i) {
            byte digit;
            char lookup = str.charAt(i);
            if (lookup >= this.decodeTable.length || (digit = this.decodeTable[lookup]) < 0) continue;
            if (idx <= 3) {
                if ((idx = (idx + 5) % 8) == 0) {
                    int n = offset++;
                    result[n] = (byte)(result[n] | digit);
                    if (offset < result.length) continue;
                    break;
                }
                int n = offset;
                result[n] = (byte)(result[n] | digit << 8 - idx);
                continue;
            }
            idx = (idx + 5) % 8;
            int n = offset++;
            result[n] = (byte)(result[n] | digit >>> idx);
            if (offset >= result.length) break;
            int n2 = offset;
            result[n2] = (byte)(result[n2] | digit << 8 - idx);
        }
        return result;
    }
}

