/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.math.BigInteger;

public class Base36 {
    private static final int BASE_COUNT = 36;

    private Base36() {
    }

    public static String encodeBytes(byte[] data) {
        return Base36.encodeBytes(data, false);
    }

    public static String encodeBytes(byte[] data, boolean toLowercase) {
        return Base36.encode(new BigInteger(1, data), toLowercase);
    }

    public static String encode(BigInteger source) {
        return Base36.encode(source, false);
    }

    public static String encode(BigInteger source, boolean toLowercase) {
        String base36 = source.toString(36);
        return toLowercase ? base36 : base36.toUpperCase();
    }

    public static byte[] decodeBytes(String str) {
        return Base36.decode(str).toByteArray();
    }

    public static BigInteger decode(String str) {
        return new BigInteger(str, 36);
    }
}

