/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import org.seppiko.commons.utils.Environment;
import org.seppiko.commons.utils.MathUtil;
import org.seppiko.commons.utils.StringUtil;

public class Base62
implements Serializable {
    private static final long serialVersionUID = -6183689559038935787L;
    private static final int BASE_COUNT = 62;
    private static final int STANDARD_BASE = 256;
    private static final char[] ALPHABET_BASE = Environment.DIGIT_ALPHABET_ALL;
    private static final byte[] DECODE_TABLE = new byte[256];

    private Base62() {
    }

    public static String encode(byte[] source) throws IllegalArgumentException {
        if (null == source || source.length == 0) {
            throw new IllegalArgumentException("source must not be empty.");
        }
        byte[] indices = Base62.convert(source, 256, 62);
        return new String(Base62.translate(indices, ALPHABET_BASE));
    }

    public static String encode(BigInteger source) throws IllegalArgumentException {
        if (source.compareTo(BigInteger.ZERO) < 0) {
            throw new IllegalArgumentException("source must not be negative.");
        }
        StringBuilder sb = new StringBuilder();
        if (BigInteger.ZERO.equals(source)) {
            sb.append(ALPHABET_BASE[0]);
        } else {
            BigInteger l = source;
            while (l.compareTo(BigInteger.ZERO) > 0) {
                BigInteger[] divmod = l.divideAndRemainder(BigInteger.valueOf(62L));
                l = divmod[0];
                sb.append(ALPHABET_BASE[divmod[1].intValue()]);
            }
        }
        return sb.toString();
    }

    public static byte[] decodeToBytes(String str) throws IllegalArgumentException {
        if (StringUtil.isNullOrEmpty(str)) {
            throw new IllegalArgumentException("string must not be empty");
        }
        byte[] prepared = Base62.translate(str.getBytes(), DECODE_TABLE);
        return Base62.convert(prepared, 62, 256);
    }

    public static BigInteger decode(String str) throws IllegalArgumentException {
        if (StringUtil.isNullOrEmpty(str)) {
            throw new IllegalArgumentException("string must not be empty");
        }
        char[] items = str.toCharArray();
        BigInteger result = BigInteger.ZERO;
        int pow = 0;
        for (char c : items) {
            result = result.add(BigInteger.valueOf(DECODE_TABLE[c]).multiply(MathUtil.pow(62, pow)));
            ++pow;
        }
        return result;
    }

    private static byte[] translate(byte[] indices, byte[] dictionary) {
        byte[] translation = new byte[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            translation[i] = dictionary[indices[i]];
        }
        return translation;
    }

    private static char[] translate(byte[] indices, char[] dictionary) {
        char[] translation = new char[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            translation[i] = dictionary[indices[i]];
        }
        return translation;
    }

    private static byte[] convert(byte[] message, int sourceBase, int targetBase) {
        int estimatedLength = Base62.estimateOutputLength(message.length, sourceBase, targetBase);
        ByteArrayOutputStream out = new ByteArrayOutputStream(estimatedLength);
        byte[] source = message;
        while (source.length > 0) {
            ByteArrayOutputStream quotient = new ByteArrayOutputStream(source.length);
            int remainder = 0;
            for (byte b : source) {
                int accumulator = (b & 0xFF) + remainder * sourceBase;
                int digit = (accumulator - accumulator % targetBase) / targetBase;
                remainder = accumulator % targetBase;
                if (quotient.size() <= 0 && digit <= 0) continue;
                quotient.write(digit);
            }
            out.write(remainder);
            source = quotient.toByteArray();
        }
        for (int i = 0; i < message.length - 1 && message[i] == 0; ++i) {
            out.write(0);
        }
        return Base62.reverse(out.toByteArray());
    }

    private static int estimateOutputLength(int inputLength, int sourceBase, int targetBase) {
        return (int)Math.ceil(Math.log(sourceBase) / Math.log(targetBase) * (double)inputLength);
    }

    private static byte[] reverse(byte[] arr) {
        int length = arr.length;
        byte[] reversed = new byte[length];
        for (int i = 0; i < length; ++i) {
            reversed[length - i - 1] = arr[i];
        }
        return reversed;
    }

    static {
        Arrays.fill(DECODE_TABLE, (byte)-1);
        for (int i = 0; i < ALPHABET_BASE.length; ++i) {
            Base62.DECODE_TABLE[Base62.ALPHABET_BASE[i]] = (byte)i;
        }
    }
}

