/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.codec;

import java.io.Serializable;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.codec.BaseNCodec;

public class Base64x
implements BaseNCodec,
Serializable {
    private static final long serialVersionUID = -7263003180491333921L;
    private static final char[] ALPHABET = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '@', '+'};
    private static final char DEFAULT_PADDING = '=';
    private static final char[] DEFAULT_NEWLINE_CHARS = CharUtil.CRLF.toCharArray();
    private static final int DEFAULT_LINEBREAK_LENGTH = 76;
    public static final Base64x BASE64X = new Base64x(ALPHABET, false);
    public static final Base64x BASE64X_NEWLINE = new Base64x(ALPHABET, true);
    public static final Base64x BASE64X_NON_PADDING = new Base64x(ALPHABET, false).withoutPadding();
    private final char[] base64Table;
    private final byte[] base64DecodeTable;
    private boolean doPadding;
    private char padding;
    private final boolean autoNewline;
    private int linebreakLength;
    private char[] newline;
    private Charset encoding;

    public Base64x(char[] base64Table, boolean autoNewline) {
        if (base64Table.length != 64) {
            throw new IllegalArgumentException("Base64 alphabet must have 64 chars.");
        }
        this.base64Table = base64Table;
        this.doPadding = true;
        this.padding = (char)61;
        this.autoNewline = autoNewline;
        this.linebreakLength = autoNewline ? 76 : -1;
        this.newline = DEFAULT_NEWLINE_CHARS;
        this.encoding = StandardCharsets.ISO_8859_1;
        this.base64DecodeTable = new byte[256];
        Arrays.fill(this.base64DecodeTable, (byte)-1);
        for (int i = 0; i < base64Table.length; ++i) {
            this.base64DecodeTable[base64Table[i]] = (byte)i;
        }
        this.base64DecodeTable[61] = -2;
    }

    public Base64x setNewline(char[] newline, int linebreakLength) throws IllegalArgumentException {
        if (!this.autoNewline) {
            throw new IllegalArgumentException("auto newline must be enable.");
        }
        this.newline = newline == null || newline.length == 0 ? DEFAULT_NEWLINE_CHARS : newline;
        this.linebreakLength = linebreakLength;
        return this;
    }

    public Base64x withoutPadding() {
        this.doPadding = false;
        this.base64DecodeTable[this.padding] = -2;
        return this;
    }

    public Base64x setPadding(char padding) throws IllegalArgumentException {
        if (padding == '\u0000') {
            throw new IllegalArgumentException("padding character must not be '\\0'.");
        }
        this.doPadding = true;
        this.padding = padding;
        this.base64DecodeTable[padding] = -2;
        return this;
    }

    public Base64x setEncoding(Charset encoding) {
        this.encoding = encoding;
        return this;
    }

    public byte[] encode(byte[] data) {
        return this.encode0(data);
    }

    @Override
    public String encodeString(byte[] data) {
        return CharUtil.charsetDecode(this.encoding, this.encode(data)).toString();
    }

    public byte[] decode(byte[] data) throws IllegalArgumentException {
        return this.decode0(data);
    }

    @Override
    public byte[] decode(String data) throws IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(data);
        return this.decode(this.encoding.encode(data).array());
    }

    private byte[] encode0(byte[] data) {
        byte[] newline = CharUtil.charsetEncode(this.encoding, CharBuffer.wrap(this.newline));
        return new Encoder(this.base64Table, newline, this.linebreakLength, this.doPadding, (byte)this.padding).encode0(data, 0, data.length);
    }

    private byte[] decode0(byte[] data) throws IllegalArgumentException {
        return new Decoder(this.base64DecodeTable, this.autoNewline, (byte)this.padding).decode0(data, 0, data.length);
    }

    private record Encoder(char[] base64Table, byte[] newline, int lineMax, boolean doPadding, byte padding) {
        private int encodedOutLength(int srclen) {
            int len;
            try {
                if (this.doPadding) {
                    len = Math.multiplyExact(4, Math.addExact(srclen, 2) / 3);
                } else {
                    int n = srclen % 3;
                    len = Math.addExact(Math.multiplyExact(4, srclen / 3), n == 0 ? 0 : n + 1);
                }
                if (this.lineMax > 0) {
                    len = Math.addExact(len, (len - 1) / this.lineMax * this.newline.length);
                }
            }
            catch (ArithmeticException ex) {
                len = -1;
            }
            return len;
        }

        private void encodeBlock(byte[] src, int sp, int sl, byte[] dst, int dp) {
            char[] base64 = this.base64Table;
            int sp0 = sp;
            int dp0 = dp;
            while (sp0 < sl) {
                int bits = (src[sp0++] & 0xFF) << 16 | (src[sp0++] & 0xFF) << 8 | src[sp0++] & 0xFF;
                dst[dp0++] = (byte)base64[bits >>> 18 & 0x3F];
                dst[dp0++] = (byte)base64[bits >>> 12 & 0x3F];
                dst[dp0++] = (byte)base64[bits >>> 6 & 0x3F];
                dst[dp0++] = (byte)base64[bits & 0x3F];
            }
        }

        private byte[] encode0(byte[] src, int off, int end) {
            char[] base64 = this.base64Table;
            byte[] dst = new byte[this.encodedOutLength(src.length)];
            int sp = off;
            int slen = (end - off) / 3 * 3;
            int sl = off + slen;
            if (this.lineMax > 0 && slen > this.lineMax / 4 * 3) {
                slen = this.lineMax / 4 * 3;
            }
            int dp = 0;
            while (sp < sl) {
                int sl0 = Math.min(sp + slen, sl);
                this.encodeBlock(src, sp, sl0, dst, dp);
                int dlen = (sl0 - sp) / 3 * 4;
                dp += dlen;
                sp = sl0;
                if (dlen != this.lineMax || sp >= end) continue;
                for (byte b : this.newline) {
                    dst[dp++] = b;
                }
            }
            if (sp < end) {
                int b0 = src[sp++] & 0xFF;
                dst[dp++] = (byte)base64[b0 >> 2];
                if (sp == end) {
                    dst[dp++] = (byte)base64[b0 << 4 & 0x3F];
                    if (this.doPadding) {
                        dst[dp++] = this.padding;
                        dst[dp++] = this.padding;
                    }
                } else {
                    int b1 = src[sp++] & 0xFF;
                    dst[dp++] = (byte)base64[b0 << 4 & 0x3F | b1 >> 4];
                    dst[dp++] = (byte)base64[b1 << 2 & 0x3F];
                    if (this.doPadding) {
                        dst[dp++] = this.padding;
                    }
                }
            }
            return dp != dst.length ? Arrays.copyOf(dst, dp) : dst;
        }
    }

    private record Decoder(byte[] base64DecodeTable, boolean autoNewline, byte padding) {
        private int decodedOutLength(byte[] src, int sp, int sl) {
            int paddings = 0;
            int len = sl - sp;
            if (len == 0) {
                return 0;
            }
            if (len < 2) {
                if (this.autoNewline && this.base64DecodeTable[0] == -1) {
                    return 0;
                }
                throw new IllegalArgumentException("Input byte[] should at least have 2 bytes for base64 bytes");
            }
            if (this.autoNewline) {
                int n = 0;
                while (sp < sl) {
                    int b;
                    if ((b = src[sp++] & 0xFF) == this.padding) {
                        len -= sl - sp + 1;
                        break;
                    }
                    if ((b = this.base64DecodeTable[b]) != -1) continue;
                    ++n;
                }
                len -= n;
            } else if (src[sl - 1] == this.padding) {
                ++paddings;
                if (src[sl - 2] == this.padding) {
                    ++paddings;
                }
            }
            if (paddings == 0 && (len & 3) != 0) {
                paddings = 4 - (len & 3);
            }
            return 3 * (int)(((long)len + 3L) / 4L) - paddings;
        }

        private int decodeBlock(byte[] src, int sp, int sl, byte[] dst, int dp) {
            int sl0 = sp + (sl - sp & 0xFFFFFFFC);
            int new_dp = dp;
            while (sp < sl0) {
                byte b4;
                byte b3;
                byte b1 = this.base64DecodeTable[src[sp++] & 0xFF];
                byte b2 = this.base64DecodeTable[src[sp++] & 0xFF];
                if ((b1 | b2 | (b3 = this.base64DecodeTable[src[sp++] & 0xFF]) | (b4 = this.base64DecodeTable[src[sp++] & 0xFF])) < 0) {
                    return new_dp - dp;
                }
                int bits0 = b1 << 18 | b2 << 12 | b3 << 6 | b4;
                dst[new_dp++] = (byte)(bits0 >> 16);
                dst[new_dp++] = (byte)(bits0 >> 8);
                dst[new_dp++] = (byte)bits0;
            }
            return new_dp - dp;
        }

        private byte[] decode0(byte[] src, int sp, int sl) throws IllegalArgumentException {
            byte[] dst = new byte[this.decodedOutLength(src, 0, src.length)];
            int dp = 0;
            int bits = 0;
            int shiftto = 18;
            while (sp < sl) {
                if (shiftto == 18 && sp < sl - 4) {
                    int dl = this.decodeBlock(src, sp, sl, dst, dp);
                    int chars_decoded = (dl + 2) / 3 * 4;
                    sp += chars_decoded;
                    dp += dl;
                }
                if (sp >= sl) break;
                int b = src[sp++] & 0xFF;
                if ((b = this.base64DecodeTable[b]) < 0) {
                    if (b == -2) {
                        if ((shiftto != 6 || sp != sl && src[sp++] == this.padding) && shiftto != 18) break;
                        throw new IllegalArgumentException("Input byte array has wrong 4-byte ending unit");
                    }
                    if (this.autoNewline) continue;
                    throw new IllegalArgumentException("Illegal base64 character " + Integer.toString(src[sp - 1], 16));
                }
                bits |= b << shiftto;
                if ((shiftto -= 6) >= 0) continue;
                dst[dp++] = (byte)(bits >> 16);
                dst[dp++] = (byte)(bits >> 8);
                dst[dp++] = (byte)bits;
                shiftto = 18;
                bits = 0;
            }
            if (shiftto == 6) {
                dst[dp++] = (byte)(bits >> 16);
            } else if (shiftto == 0) {
                dst[dp++] = (byte)(bits >> 16);
                dst[dp++] = (byte)(bits >> 8);
            } else if (shiftto == 12) {
                throw new IllegalArgumentException("Last unit does not have enough valid bits");
            }
            while (sp < sl) {
                if (this.autoNewline && this.base64DecodeTable[src[sp++] & 0xFF] < 0) continue;
                throw new IllegalArgumentException("Input byte array has incorrect ending byte at " + sp);
            }
            return dp != dst.length ? Arrays.copyOf(dst, dp) : dst;
        }
    }
}

