/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.util.zip.Checksum;

public class CRC64ECMA182
implements Checksum {
    private static final long ECMA182INIT = 0L;
    private static final long ECMA182POLY = -3932672073523589310L;
    private static final int TABLE_LENGTH = 256;
    private static final long[] table = new long[256];
    private long crc = 0L;

    @Override
    public void update(int b) {
        this.updateByte((byte)(b & 0xFF));
    }

    @Override
    public void update(byte[] b, int off, int len) throws NullPointerException, ArrayIndexOutOfBoundsException {
        this.updateCheck(b, off, len);
        int i = off;
        while (len > 0) {
            this.updateByte(b[i]);
            ++i;
            --len;
        }
    }

    private void updateByte(byte b) {
        this.crc ^= 0xFFFFFFFFFFFFFFFFL;
        this.crc = this.crc >>> 8 ^ table[(int)(this.crc ^ (long)b) & 0xFF];
        this.crc ^= 0xFFFFFFFFFFFFFFFFL;
    }

    private void updateCheck(byte[] b, int off, int len) throws NullPointerException, ArrayIndexOutOfBoundsException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off > b.length - len) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    @Override
    public long getValue() {
        return this.crc;
    }

    @Override
    public void reset() {
        this.crc = 0L;
    }

    static {
        for (int n = 0; n < 256; ++n) {
            long crc = n;
            for (int k = 0; k < 8; ++k) {
                crc = (crc & 1L) == 1L ? crc >>> 1 ^ 0xC96C5795D7870F42L : crc >>> 1;
            }
            CRC64ECMA182.table[n] = crc;
        }
    }
}

