/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.util.zip.CRC32C;
import org.seppiko.commons.utils.MathUtil;
import org.seppiko.commons.utils.codec.HexUtil;
import org.seppiko.commons.utils.crypto.CRC16MAXIM;
import org.seppiko.commons.utils.crypto.CRC24;
import org.seppiko.commons.utils.crypto.CRC64ECMA182;

public class CRCUtil {
    private CRCUtil() {
    }

    public static class CRC64E {
        private static final CRC64ECMA182 crc64e = new CRC64ECMA182();

        public static long encode(byte[] data) {
            crc64e.update(data);
            return crc64e.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc64 = CRC64E.encode(data);
            return MathUtil.convertDecimalTo(crc64, HexUtil.HEXADECIMAL);
        }
    }

    public static class CRC32 {
        private static final CRC32C crc32 = new CRC32C();

        public static long encode(byte[] data) {
            crc32.update(data);
            return crc32.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc32 = CRC32.encode(data);
            return MathUtil.convertDecimalTo(crc32, HexUtil.HEXADECIMAL);
        }
    }

    public static class CRC24C {
        private static final CRC24 crc24 = new CRC24();

        public static long encode(byte[] data) {
            crc24.update(data);
            return crc24.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc24 = CRC24C.encode(data);
            return MathUtil.convertDecimalTo(crc24, HexUtil.HEXADECIMAL);
        }
    }

    public static class CRC16M {
        private static final CRC16MAXIM crc16MAXIM = new CRC16MAXIM();

        public static long encode(byte[] data) {
            crc16MAXIM.update(data);
            return crc16MAXIM.getValue();
        }

        public static String encodeString(byte[] data) {
            long crc16 = CRC16M.encode(data);
            return MathUtil.convertDecimalTo(crc16, HexUtil.HEXADECIMAL);
        }
    }
}

