/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKeyFactory;
import org.seppiko.commons.utils.crypto.CryptoUtil;
import org.seppiko.commons.utils.crypto.KeyStoreAlgorithms;

public class KeyUtil {
    private KeyUtil() {
    }

    public static byte[] secretKeyFactory(String algorithm, Provider provider, KeySpec keySpec) throws NoSuchAlgorithmException, InvalidKeySpecException, NullPointerException {
        return KeyUtil.secretKeyFactory(algorithm, provider).generateSecret(keySpec).getEncoded();
    }

    public static SecretKeyFactory secretKeyFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException {
        if (provider == CryptoUtil.NONPROVIDER) {
            return SecretKeyFactory.getInstance(algorithm);
        }
        return SecretKeyFactory.getInstance(algorithm, provider);
    }

    public static KeyFactory keyFactory(String algorithm, Provider provider) throws NullPointerException, NoSuchAlgorithmException, IllegalArgumentException {
        if (provider == CryptoUtil.NONPROVIDER) {
            return KeyFactory.getInstance(algorithm);
        }
        return KeyFactory.getInstance(algorithm, provider);
    }

    public static byte[] keyAgreement(String algorithm, Provider provider, Key privateKey, Key publicKey) throws NoSuchAlgorithmException, NullPointerException, InvalidKeyException {
        KeyAgreement ka = provider == CryptoUtil.NONPROVIDER ? KeyAgreement.getInstance(algorithm) : KeyAgreement.getInstance(algorithm, provider);
        ka.init(privateKey);
        ka.doPhase(publicKey, true);
        return ka.generateSecret();
    }

    public static KeyStore keyStore(KeyStoreAlgorithms type, InputStream is, char[] password) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(type.getType());
        keyStore.load(is, password);
        return keyStore;
    }

    public static KeyStore keyStore(KeyStoreAlgorithms type, KeyStore.LoadStoreParameter loadStore) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore keyStore = KeyStore.getInstance(type.getType());
        keyStore.load(loadStore);
        return keyStore;
    }
}

