/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.seppiko.commons.utils.crypto.CryptoUtil;

public class SignatureUtil {
    private SignatureUtil() {
    }

    public static Signature signature(String algorithm, Provider provider) throws NoSuchAlgorithmException, NullPointerException {
        if (provider == CryptoUtil.NONPROVIDER) {
            return Signature.getInstance(algorithm);
        }
        return Signature.getInstance(algorithm, provider);
    }

    public static byte[] sign(String algorithm, PrivateKey privateKey, byte[] rawData) throws NoSuchAlgorithmException, NullPointerException, InvalidKeyException, SignatureException {
        return SignatureUtil.sign(algorithm, CryptoUtil.NONPROVIDER, privateKey, rawData);
    }

    public static boolean verify(String algorithm, PublicKey publicKey, byte[] rawData, byte[] signedData) throws NoSuchAlgorithmException, NullPointerException, InvalidKeyException, SignatureException {
        return SignatureUtil.verify(algorithm, CryptoUtil.NONPROVIDER, publicKey, rawData, signedData);
    }

    public static byte[] sign(String algorithm, Provider provider, PrivateKey privateKey, byte[] rawData) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException, InvalidKeyException, SignatureException {
        Signature signature = SignatureUtil.signature(algorithm, provider);
        signature.initSign(privateKey);
        signature.update(rawData);
        return signature.sign();
    }

    public static boolean verify(String algorithm, Provider provider, PublicKey publicKey, byte[] rawData, byte[] signedData) throws NoSuchAlgorithmException, NullPointerException, IllegalArgumentException, InvalidKeyException, SignatureException {
        Signature signature = SignatureUtil.signature(algorithm, provider);
        signature.initVerify(publicKey);
        signature.update(rawData);
        return signature.verify(signedData);
    }
}

