/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.crypto.spec;

import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECField;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EdDSAParameterSpec;
import java.security.spec.EllipticCurve;
import javax.crypto.spec.ChaCha20ParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.PSource;

public class ParameterSpacUtil {
    private ParameterSpacUtil() {
    }

    public static GCMParameterSpec getGCM(int tLen, byte[] src) throws NullPointerException, IllegalArgumentException {
        if (src == null) {
            throw new NullPointerException("IV source buffer missing");
        }
        return ParameterSpacUtil.getGCM(tLen, src, 0, src.length);
    }

    public static GCMParameterSpec getGCM(int tLen, byte[] src, int off, int len) throws IllegalArgumentException {
        return new GCMParameterSpec(tLen, src, off, len);
    }

    public static IvParameterSpec getIV(byte[] iv) throws NullPointerException {
        if (iv == null) {
            throw new NullPointerException("IV missing");
        }
        return ParameterSpacUtil.getIV(iv, 0, iv.length);
    }

    public static IvParameterSpec getIV(byte[] iv, int off, int len) {
        return new IvParameterSpec(iv, off, len);
    }

    public static PBEParameterSpec getPBE(byte[] salt, int iterationCount) throws NullPointerException {
        return ParameterSpacUtil.getPBE(salt, iterationCount, null);
    }

    public static PBEParameterSpec getPBE(byte[] salt, int iterationCount, AlgorithmParameterSpec paramSpec) throws NullPointerException {
        if (salt == null) {
            throw new NullPointerException("Salt missing");
        }
        return new PBEParameterSpec(salt, iterationCount, paramSpec);
    }

    public static DHParameterSpec getDH(BigInteger p, BigInteger g) {
        return ParameterSpacUtil.getDH(p, g, 0);
    }

    public static DHParameterSpec getDH(BigInteger p, BigInteger g, int l) {
        return new DHParameterSpec(p, g, l);
    }

    public static ECParameterSpec getEC(ECField field, BigInteger fristCoefficient, BigInteger secondfficient, BigInteger affineX, BigInteger affineY, BigInteger generator, int cofactor) throws NullPointerException, IllegalArgumentException {
        EllipticCurve curve = new EllipticCurve(field, fristCoefficient, secondfficient);
        ECPoint point = new ECPoint(affineX, affineY);
        return new ECParameterSpec(curve, point, generator, cofactor);
    }

    public static ChaCha20ParameterSpec getChacha20(byte[] nonce, int counter) throws NullPointerException, IllegalArgumentException {
        if (nonce == null) {
            throw new NullPointerException("Nonce must be not null");
        }
        if (nonce.length != 12) {
            throw new IllegalArgumentException("Nonce must be 12-bytes in length");
        }
        return new ChaCha20ParameterSpec(nonce, counter);
    }

    public static OAEPParameterSpec getOAEP(String mdName, String mgfName, AlgorithmParameterSpec mgfSpec, PSource pSrc) throws NullPointerException {
        if (pSrc == null) {
            pSrc = PSource.PSpecified.DEFAULT;
        }
        return new OAEPParameterSpec(mdName, mgfName, mgfSpec, pSrc);
    }

    public static EdDSAParameterSpec getEdDSA(boolean prehash, byte[] context) throws InvalidParameterException {
        if (context == null) {
            return new EdDSAParameterSpec(prehash);
        }
        return new EdDSAParameterSpec(prehash, context);
    }
}

