/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLContext;
import org.seppiko.commons.utils.http.HttpClientUtil;
import org.seppiko.commons.utils.http.HttpResponseException;
import org.seppiko.commons.utils.http.HttpResponseImpl;
import org.seppiko.commons.utils.http.HttpRuntimeException;
import org.seppiko.commons.utils.http.TLSUtil;

public class AsyncHttpClientUtil
extends HttpClientUtil {
    AsyncHttpClientUtil() {
    }

    public static HttpResponse<String> getAsyncResponseString(HttpRequest req, SSLContext sslContext, InetSocketAddress proxy) throws HttpRuntimeException, IllegalArgumentException, HttpResponseException {
        return AsyncHttpClientUtil.httpResponse(AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofString(), sslContext, proxy));
    }

    public static HttpResponse<byte[]> getAsyncResponseByteArray(HttpRequest req, SSLContext sslContext, InetSocketAddress proxy) throws HttpRuntimeException, IllegalArgumentException, HttpResponseException {
        return AsyncHttpClientUtil.httpResponse(AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofByteArray(), sslContext, proxy));
    }

    public static HttpResponse<InputStream> getAsyncResponseInputStream(HttpRequest req, SSLContext sslContext, InetSocketAddress proxy) throws HttpRuntimeException, IllegalArgumentException, HttpResponseException {
        return AsyncHttpClientUtil.httpResponse(AsyncHttpClientUtil.getAsyncResponseRaw(req, HttpResponse.BodyHandlers.ofInputStream(), sslContext, proxy));
    }

    private static <T> HttpResponse<T> httpResponse(CompletableFuture<HttpResponse<T>> resp) throws HttpRuntimeException {
        return new HttpResponseImpl<T>(resp);
    }

    protected static <T> CompletableFuture<HttpResponse<T>> getAsyncResponseRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler, SSLContext sslContext, InetSocketAddress proxy) throws HttpResponseException {
        try {
            HttpClient.Builder builder = HttpClient.newBuilder();
            if (Objects.nonNull(proxy)) {
                builder = builder.proxy(ProxySelector.of(proxy));
            }
            if (sslContext != TLSUtil.NULL_SSL_CONTEXT) {
                builder = builder.sslContext(sslContext);
            }
            return builder.build().sendAsync(req, responseBodyHandler);
        }
        catch (UncheckedIOException | IllegalArgumentException ex) {
            throw new HttpResponseException(ex);
        }
    }
}

