/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import org.seppiko.commons.utils.http.HttpClientException;
import org.seppiko.commons.utils.http.HttpHeaders;
import org.seppiko.commons.utils.http.HttpInterruptedException;
import org.seppiko.commons.utils.http.HttpMethod;
import org.seppiko.commons.utils.http.HttpResponseException;
import org.seppiko.commons.utils.http.HttpRuntimeException;
import org.seppiko.commons.utils.http.HttpTimeoutException;
import org.seppiko.commons.utils.http.TLSUtil;

public class HttpClientUtil {
    HttpClientUtil() {
    }

    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, HttpHeaders headers, String requestBody) throws URISyntaxException, IllegalArgumentException, NullPointerException, HttpRuntimeException {
        if (Objects.isNull(headers)) {
            headers = HttpHeaders.newHeaders();
        }
        HttpRequest.BodyPublisher requestBodyPublisher = Objects.nonNull(requestBody) ? HttpRequest.BodyPublishers.ofString(requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headers.getHeaderMap(), requestBodyPublisher);
    }

    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, HttpHeaders headers, InputStream requestBody) throws URISyntaxException, IllegalArgumentException, NullPointerException, HttpRuntimeException {
        if (Objects.isNull(headers)) {
            headers = HttpHeaders.newHeaders();
        }
        HttpRequest.BodyPublisher requestBodyPublisher = Objects.nonNull(requestBody) ? HttpRequest.BodyPublishers.ofInputStream(() -> requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headers.getHeaderMap(), requestBodyPublisher);
    }

    public static HttpRequest getRequest(String url, HttpMethod method, int timeout, HttpHeaders headers, byte[] requestBody) throws URISyntaxException, IllegalArgumentException, NullPointerException, HttpRuntimeException {
        if (Objects.isNull(headers)) {
            headers = HttpHeaders.newHeaders();
        }
        HttpRequest.BodyPublisher requestBodyPublisher = Objects.nonNull(requestBody) ? HttpRequest.BodyPublishers.ofByteArray(requestBody) : HttpRequest.BodyPublishers.noBody();
        return HttpClientUtil.getRequestRaw(new URI(url), method, timeout, headers.getHeaderMap(), requestBodyPublisher);
    }

    public static HttpResponse<String> getResponseString(HttpRequest req, SSLContext sslContext, InetSocketAddress proxy) throws HttpClientException, HttpInterruptedException {
        return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofString(), sslContext, proxy);
    }

    public static HttpResponse<byte[]> getResponseByteArray(HttpRequest req, SSLContext sslContext, InetSocketAddress proxy) throws HttpClientException, HttpInterruptedException {
        return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofByteArray(), sslContext, proxy);
    }

    public static HttpResponse<InputStream> getResponseInputStream(HttpRequest req, SSLContext sslContext, InetSocketAddress proxy) throws HttpClientException, HttpInterruptedException {
        return HttpClientUtil.getResponseRaw(req, HttpResponse.BodyHandlers.ofInputStream(), sslContext, proxy);
    }

    protected static HttpRequest getRequestRaw(URI uri, HttpMethod method, int timeout, Map<String, String> headers, HttpRequest.BodyPublisher requestBody) throws IllegalArgumentException, IllegalStateException, HttpTimeoutException {
        HttpRequest.Builder builder = HttpRequest.newBuilder().uri(uri).method(method.name(), requestBody);
        if (!headers.isEmpty()) {
            headers.forEach(builder::header);
        }
        try {
            builder = builder.timeout(Duration.ofSeconds(timeout));
        }
        catch (IllegalArgumentException ex) {
            throw new HttpTimeoutException("HTTP request timeout.");
        }
        return builder.build();
    }

    protected static <T> HttpResponse<T> getResponseRaw(HttpRequest req, HttpResponse.BodyHandler<T> responseBodyHandler, SSLContext sslContext, InetSocketAddress proxy) throws HttpInterruptedException, HttpResponseException, SecurityException {
        try {
            HttpClient.Builder builder = HttpClient.newBuilder();
            if (Objects.nonNull(proxy)) {
                builder = builder.proxy(ProxySelector.of(proxy));
            }
            if (sslContext != TLSUtil.NULL_SSL_CONTEXT) {
                builder = builder.sslContext(sslContext);
            }
            return builder.build().send(req, responseBodyHandler);
        }
        catch (InterruptedException ex) {
            throw new HttpInterruptedException(ex);
        }
        catch (IOException | IllegalArgumentException ex) {
            throw new HttpResponseException(ex);
        }
    }

    protected static <T> HttpRequest.BodyPublisher getBodyPublisher(T requestBody) throws UnsupportedOperationException {
        if (Objects.isNull(requestBody)) {
            return HttpRequest.BodyPublishers.noBody();
        }
        Class<Object> type = requestBody.getClass();
        if (type.isAssignableFrom(CharSequence.class)) {
            return HttpRequest.BodyPublishers.ofString(requestBody.toString());
        }
        if (type.isAssignableFrom(InputStream.class)) {
            return HttpRequest.BodyPublishers.ofInputStream(() -> (InputStream)requestBody);
        }
        if (requestBody instanceof byte[]) {
            return HttpRequest.BodyPublishers.ofByteArray((byte[])requestBody);
        }
        throw new UnsupportedOperationException("Can NOT found supported type");
    }

    protected static <T> HttpResponse.BodyHandler<?> getBodyHandler(Class<T> type) {
        if (type == null || type.isAssignableFrom(String.class)) {
            return HttpResponse.BodyHandlers.ofString();
        }
        if (type.isAssignableFrom(InputStream.class)) {
            return HttpResponse.BodyHandlers.ofInputStream();
        }
        return HttpResponse.BodyHandlers.ofByteArray();
    }
}

