/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.seppiko.commons.utils.StringUtil;

public class HttpHeaders
implements Serializable {
    private static final long serialVersionUID = -7241706861359666774L;
    private static final String HTTP_HEADER_VALUE_SEPARATOR = "; ";
    private final LinkedHashMap<String, ArrayList<String>> headers = new LinkedHashMap();

    private HttpHeaders() {
    }

    private HttpHeaders(Map<String, List<String>> headerMap) {
        headerMap.forEach((k, v) -> this.headers.put((String)k, new ArrayList(v)));
    }

    public static HttpHeaders newHeaders() {
        return new HttpHeaders();
    }

    public static HttpHeaders newHeaders(Map<String, List<String>> headerMap) {
        return new HttpHeaders(headerMap);
    }

    public HttpHeaders setHeaders(String name, String ... values) {
        return this.setHeaders(name, Arrays.asList(values));
    }

    public HttpHeaders setHeaders(String name, List<String> values) {
        this.headers.put(name, new ArrayList<String>(values));
        return this;
    }

    public HttpHeaders addHeaders(String name, String ... values) throws IllegalArgumentException {
        return this.addHeaders(name, Arrays.asList(values));
    }

    public HttpHeaders addHeaders(String name, List<String> values) throws IllegalArgumentException {
        if (this.headers.containsKey(name)) {
            ArrayList<String> valueOld = this.headers.get(name);
            ArrayList<String> valueNew = new ArrayList<String>(values);
            for (String value : valueOld) {
                if (valueNew.contains(value)) continue;
                try {
                    valueNew.add(value);
                }
                catch (ClassCastException | IllegalArgumentException | NullPointerException | UnsupportedOperationException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
            this.headers.put(name, valueNew);
        } else {
            this.setHeaders(name, values);
        }
        return this;
    }

    public LinkedHashMap<String, String> getHeaderMap() throws IllegalCallerException, IllegalArgumentException {
        LinkedHashMap<String, String> headerMap = new LinkedHashMap<String, String>();
        if (!this.headers.isEmpty()) {
            this.headers.forEach((name, value) -> headerMap.put((String)name, this.valuesHandler((ArrayList<String>)value)));
        }
        return headerMap;
    }

    private String valuesHandler(ArrayList<String> valueList) {
        return StringUtil.convertJoinerString(HTTP_HEADER_VALUE_SEPARATOR, (String[])valueList.toArray(String[]::new));
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ");
        this.headers.forEach((k, v) -> sj.add("\"" + k + "\": " + v.toString()));
        return "{ " + sj + " }";
    }
}

