/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.net.ssl.SSLSession;
import org.seppiko.commons.utils.http.HttpInterruptedException;
import org.seppiko.commons.utils.http.HttpRuntimeException;

public class HttpResponseImpl<T>
implements HttpResponse<T> {
    private final CompletableFuture<HttpResponse<T>> resp;

    public HttpResponseImpl(CompletableFuture<HttpResponse<T>> resp) {
        this.resp = resp;
    }

    @Override
    public int statusCode() {
        try {
            return (Integer)((CompletableFuture)this.resp.thenApply(HttpResponse::statusCode)).get();
        }
        catch (CancellationException | ExecutionException e) {
            throw new HttpRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw this.interrupt(e);
        }
    }

    @Override
    public HttpRequest request() {
        try {
            return (HttpRequest)((CompletableFuture)this.resp.thenApply(HttpResponse::request)).get();
        }
        catch (CancellationException | ExecutionException e) {
            throw new HttpRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw this.interrupt(e);
        }
    }

    @Override
    public Optional<HttpResponse<T>> previousResponse() {
        try {
            return (Optional)((CompletableFuture)this.resp.thenApply(HttpResponse::previousResponse)).get();
        }
        catch (CancellationException | ExecutionException e) {
            throw new HttpRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw this.interrupt(e);
        }
    }

    @Override
    public HttpHeaders headers() {
        try {
            return (HttpHeaders)((CompletableFuture)this.resp.thenApply(HttpResponse::headers)).get();
        }
        catch (CancellationException | ExecutionException e) {
            throw new HttpRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw this.interrupt(e);
        }
    }

    @Override
    public T body() {
        try {
            return ((CompletableFuture)this.resp.thenApply(HttpResponse::body)).get();
        }
        catch (CancellationException | ExecutionException e) {
            throw new HttpRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw this.interrupt(e);
        }
    }

    @Override
    public Optional<SSLSession> sslSession() {
        try {
            return (Optional)((CompletableFuture)this.resp.thenApply(HttpResponse::sslSession)).get();
        }
        catch (CancellationException | ExecutionException e) {
            throw new HttpRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw this.interrupt(e);
        }
    }

    @Override
    public URI uri() {
        try {
            return (URI)((CompletableFuture)this.resp.thenApply(HttpResponse::uri)).get();
        }
        catch (CancellationException | ExecutionException e) {
            throw new HttpRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw this.interrupt(e);
        }
    }

    @Override
    public HttpClient.Version version() {
        try {
            return (HttpClient.Version)((Object)((CompletableFuture)this.resp.thenApply(HttpResponse::version)).get());
        }
        catch (CancellationException | ExecutionException e) {
            throw new HttpRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw this.interrupt(e);
        }
    }

    private RuntimeException interrupt(InterruptedException ex) throws HttpInterruptedException {
        Thread.currentThread().interrupt();
        return new HttpInterruptedException(ex);
    }
}

