/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.Objects;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.seppiko.commons.utils.Environment;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.crypto.CryptoUtil;
import org.seppiko.commons.utils.crypto.KeyStoreAlgorithms;
import org.seppiko.commons.utils.crypto.KeyUtil;
import org.seppiko.commons.utils.http.DefaultX509TrustManager;
import org.seppiko.commons.utils.http.HttpTLSException;
import org.seppiko.commons.utils.http.TLSProtocol;

public class TLSUtil {
    public static final TrustManager[] DEFAULT_TRUST_MANAGERS = new TrustManager[]{new DefaultX509TrustManager()};
    public static final SSLContext NULL_SSL_CONTEXT = null;

    private TLSUtil() {
    }

    public static KeyManagerFactory keyManagerFactory(Provider provider) throws NoSuchAlgorithmException {
        return TLSUtil.keyManagerFactory("PKIX", provider);
    }

    public static KeyManagerFactory keyManagerFactory(String algorithm, Provider provider) throws NoSuchAlgorithmException {
        if (StringUtil.isNullOrEmpty(algorithm)) {
            algorithm = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (provider == CryptoUtil.NONPROVIDER) {
            return KeyManagerFactory.getInstance(algorithm);
        }
        return KeyManagerFactory.getInstance(algorithm, provider);
    }

    public static KeyManager[] keyManagers(KeyStore store, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException {
        KeyManagerFactory kmf = TLSUtil.keyManagerFactory(CryptoUtil.NONPROVIDER);
        kmf.init(store, password);
        return kmf.getKeyManagers();
    }

    public static KeyManager[] keyManagers(ManagerFactoryParameters spec) throws NoSuchAlgorithmException, UnrecoverableKeyException, KeyStoreException, InvalidAlgorithmParameterException {
        KeyManagerFactory kmf = TLSUtil.keyManagerFactory(CryptoUtil.NONPROVIDER);
        kmf.init(spec);
        return kmf.getKeyManagers();
    }

    public static SSLContext getSSLContext(File certFile, String certPass) {
        try {
            return TLSUtil.getSSLContext(TLSProtocol.TLSv12, KeyStoreAlgorithms.PKCS12, new FileInputStream(certFile), certPass, DEFAULT_TRUST_MANAGERS);
        }
        catch (FileNotFoundException | NullPointerException exception) {
            return NULL_SSL_CONTEXT;
        }
    }

    public static SSLContext getSSLContext(TLSProtocol protocol, KeyStoreAlgorithms storeAlgorithms, InputStream certIs, String password, TrustManager[] tms) throws HttpTLSException, NullPointerException {
        Objects.requireNonNull(protocol, "TLS protocol must be not null");
        Objects.requireNonNull(storeAlgorithms, "KeyStore algorithm must be not null");
        Objects.requireNonNull(certIs, "Certificate cannot found");
        try {
            return TLSUtil.getSSLContext(protocol, TLSUtil.keyManagers(KeyUtil.keyStore(storeAlgorithms, certIs, password.toCharArray()), password.toCharArray()), tms);
        }
        catch (IOException | RuntimeException | GeneralSecurityException ex) {
            throw new HttpTLSException(ex);
        }
    }

    public static SSLContext getSSLContext(TLSProtocol protocol, KeyStoreAlgorithms storeAlgorithms, TrustManager[] tms) {
        Objects.requireNonNull(protocol, "TLS protocol must be not null");
        Objects.requireNonNull(storeAlgorithms, "KeyStore algorithm must be not null");
        try {
            return TLSUtil.getSSLContext(protocol, TLSUtil.keyManagers(KeyUtil.keyStore(storeAlgorithms, null), Environment.EMPTY_CHAR_ARRAY), tms);
        }
        catch (IOException | RuntimeException | GeneralSecurityException ex) {
            throw new HttpTLSException(ex);
        }
    }

    public static SSLContext getSSLContext(TLSProtocol protocol, KeyManager[] kms, TrustManager[] tms) throws NoSuchAlgorithmException, KeyManagementException {
        return TLSUtil.getSSLContext(protocol, kms, tms, new SecureRandom());
    }

    public static SSLContext getSSLContext(TLSProtocol protocol, KeyManager[] kms, TrustManager[] tms, SecureRandom secRand) throws KeyManagementException, NoSuchAlgorithmException {
        SSLContext sslContext = SSLContext.getInstance(protocol.getName());
        sslContext.init(kms, tms, secRand);
        return sslContext;
    }
}

