/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.net.URI;
import java.util.Objects;
import org.seppiko.commons.utils.CharUtil;
import org.seppiko.commons.utils.RegexUtil;

public class URIUtil {
    private URIUtil() {
    }

    public static URI getUri(String uri) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(uri, "URI must be not NULL.");
        return URI.create(uri);
    }

    public static String getLastPathname(String uri) throws IllegalArgumentException, NullPointerException {
        String filename = URIUtil.getUri(uri).getPath();
        return filename.substring(filename.lastIndexOf(CharUtil.SOLIDUS.charValue()) + 1);
    }

    public static String getFileExtension(String filename) throws NullPointerException {
        Objects.requireNonNull(filename);
        if (filename.lastIndexOf(CharUtil.FULL_STOP.charValue()) >= 0 && RegexUtil.matches(".*\\p{Alnum}+$", filename)) {
            return filename.substring(filename.lastIndexOf(CharUtil.FULL_STOP.charValue()) + 1).toLowerCase();
        }
        return null;
    }
}

