/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.http;

import java.net.URI;
import java.util.Arrays;
import java.util.Objects;
import java.util.StringJoiner;
import org.seppiko.commons.utils.NumberUtil;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.http.URIUtil;

public final class UriBuilder {
    private String scheme;
    private String userInfo;
    private String hostname;
    private Integer port;
    private final StringJoiner pathJoiner = new StringJoiner("/");
    private final StringJoiner queryJoiner = new StringJoiner("&", "?", "");
    private String fragment;

    private UriBuilder() {
    }

    public static UriBuilder fromString(String url) throws NullPointerException, IllegalArgumentException {
        URI uri = URIUtil.getUri(url);
        String userInfo = uri.getUserInfo();
        String query = uri.getQuery();
        UriBuilder builder = new UriBuilder().withScheme(uri.getScheme());
        if (!StringUtil.isNullOrEmpty(userInfo)) {
            if (userInfo.contains(":")) {
                String[] user = userInfo.split(":");
                builder.withUserInfo(user[0], user[1]);
            } else {
                builder.withUserInfo(userInfo, "");
            }
        }
        builder.withHostname(uri.getHost()).withPort(uri.getPort()).addPath(uri.getPath());
        if (!StringUtil.isNullOrEmpty(query)) {
            String[] params = query.split("&");
            Arrays.stream(params).forEach(param -> {
                String[] part = param.split("=");
                builder.addQuery(part[0], part[1]);
            });
        }
        if (!StringUtil.isNullOrEmpty(uri.getFragment())) {
            builder.withFragment(uri.getFragment());
        }
        return builder;
    }

    public static UriBuilder create() {
        return new UriBuilder();
    }

    public UriBuilder withScheme(String scheme) {
        Objects.requireNonNull(scheme);
        this.scheme = scheme;
        return this;
    }

    public UriBuilder withUserInfo(String username, String password) {
        if (!StringUtil.isNullOrEmpty(username) && !StringUtil.isNullOrEmpty(password)) {
            this.userInfo = String.format("%s:%s", username, password);
        } else if (!StringUtil.isNullOrEmpty(username)) {
            this.userInfo = username;
        } else {
            throw new NullPointerException("Not found user info");
        }
        return this;
    }

    public UriBuilder withHostname(String hostname) {
        Objects.requireNonNull(hostname);
        if (hostname.endsWith("/")) {
            hostname = hostname.substring(0, hostname.length() - 1);
        }
        this.hostname = hostname;
        return this;
    }

    public UriBuilder withPort(int port) {
        this.port = NumberUtil.between(port, 1, 65535) ? Integer.valueOf(port) : null;
        return this;
    }

    public UriBuilder addPath(String path) {
        Objects.requireNonNull(path);
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        this.pathJoiner.add(path);
        return this;
    }

    public UriBuilder addQuery(String name, String value) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(value);
        this.queryJoiner.add(String.format("%s=%s", name, value));
        return this;
    }

    public UriBuilder withFragment(String fragment) {
        if (!StringUtil.isNullOrEmpty(fragment)) {
            this.fragment = fragment;
        }
        return this;
    }

    public String toUri() {
        StringBuilder uriSB = new StringBuilder();
        uriSB.append(this.scheme);
        uriSB.append("://");
        if (!StringUtil.isNullOrEmpty(this.userInfo)) {
            uriSB.append(this.userInfo);
            uriSB.append("@");
        }
        uriSB.append(this.hostname);
        if (this.port != null) {
            uriSB.append(":");
            uriSB.append(this.port);
        }
        uriSB.append("/");
        if (this.pathJoiner.length() > 0) {
            uriSB.append(this.pathJoiner.toString());
        }
        if (this.queryJoiner.length() > 0) {
            uriSB.append(this.queryJoiner.toString());
        }
        if (this.fragment != null) {
            uriSB.append("#");
            uriSB.append(this.fragment);
        }
        return uriSB.toString();
    }

    public URI toURI() {
        return URIUtil.getUri(this.toUri());
    }
}

