/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Objects;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.seppiko.commons.utils.StringUtil;

public class ConnectionUtil {
    private ConnectionUtil() {
    }

    public static Connection getConnection(String driverClazzName, String url, String username, String password) throws SQLException, ClassNotFoundException, IllegalArgumentException, NullPointerException {
        if (StringUtil.isNullOrEmpty(driverClazzName)) {
            throw new IllegalArgumentException("Driver class name must be not null");
        }
        Class.forName(driverClazzName);
        return ConnectionUtil.getConnection(url, username, password);
    }

    public static Connection getConnection(String url, String username, String password) throws SQLException, NullPointerException {
        Objects.requireNonNull(url, "JDBC url must be not null.");
        return DriverManager.getConnection(url, username, password);
    }

    public static DataSource getDataSourceWithJNDI(String jndiName) throws NamingException {
        return (DataSource)new InitialContext().lookup(jndiName);
    }
}

