/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.jdbc;

import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.seppiko.commons.utils.reflect.ReflectionUtil;

public class ResultSetUtil {
    private ResultSetUtil() {
    }

    public static ArrayList<HashMap<String, Object>> convert(ResultSet resultSet) throws SQLException {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        ResultSetMetaData row = resultSet.getMetaData();
        int colSize = row.getColumnCount();
        while (resultSet.next()) {
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (int i = 0; i < colSize; ++i) {
                rowMap.put(row.getColumnName(i), resultSet.getObject(i));
            }
            result.add(rowMap);
        }
        return result;
    }

    public static <T> ArrayList<T> convert(ResultSet resultSet, Class<T> clazz) throws SQLException, IllegalAccessException {
        ArrayList<T> result = new ArrayList<T>();
        while (resultSet.next()) {
            T t;
            Field[] fields;
            try {
                fields = ReflectionUtil.getDeclaredFields(clazz);
            }
            catch (SecurityException e) {
                try {
                    fields = ReflectionUtil.getRecordFields(clazz);
                }
                catch (NoSuchFieldException | SecurityException ex) {
                    throw new IllegalAccessException("Failed to get entity class field.");
                }
            }
            Class[] paramTypes = new Class[fields.length];
            Object[] args = new Object[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                paramTypes[i] = fields[i].getType();
                args[i] = resultSet.getObject(i + 1);
            }
            try {
                t = ReflectionUtil.setRecordAllFields(clazz, paramTypes, args);
            }
            catch (IllegalArgumentException | ReflectiveOperationException e) {
                try {
                    t = ReflectionUtil.newInstance(clazz);
                    for (Field field : fields) {
                        ReflectionUtil.setField(field, t, field.get(t));
                    }
                }
                catch (ReflectiveOperationException ex) {
                    throw new IllegalAccessException("Call parameterless constructor failed.");
                }
            }
            result.add(t);
        }
        return result;
    }

    public static boolean close(ResultSet resultSet) throws SQLException {
        if (resultSet != null && !resultSet.isClosed()) {
            resultSet.close();
            return true;
        }
        return false;
    }
}

