/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.jdbc;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.util.Objects;
import org.seppiko.commons.utils.StringUtil;
import org.seppiko.commons.utils.jdbc.SqlTypeUtil;

public class SQLExecutor {
    private final Connection conn;

    public SQLExecutor(Connection conn) throws NullPointerException {
        Objects.requireNonNull(conn, "Connection must not be null.");
        this.conn = conn;
    }

    public ResultSet query(String sql) throws SQLException, IllegalArgumentException {
        this.checkSQL(sql);
        return this.conn.createStatement().executeQuery(this.sqlFilter(sql));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultSet query(String sql, Object ... params) throws SQLException, IllegalArgumentException {
        this.checkSQL(sql);
        Statement pstmt = null;
        try {
            pstmt = this.conn.prepareStatement(this.sqlFilter(sql));
            if (params.length == 1) {
                SQLExecutor.setParameter((PreparedStatement)pstmt, 1, params[0]);
            } else {
                for (int i = 0; i < params.length; ++i) {
                    SQLExecutor.setParameter((PreparedStatement)pstmt, i + 1, params[i]);
                }
            }
            ResultSet resultSet = pstmt.executeQuery();
            return resultSet;
        }
        finally {
            if (pstmt != null && !pstmt.isClosed()) {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String sql) throws SQLException, IllegalArgumentException {
        this.checkSQL(sql);
        Statement stmt = null;
        try {
            stmt = this.conn.createStatement();
            int n = stmt.executeUpdate(this.sqlFilter(sql));
            return n;
        }
        finally {
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String sql, Object ... params) throws SQLException, IllegalArgumentException {
        this.checkSQL(sql);
        Statement pstmt = null;
        try {
            pstmt = this.conn.prepareStatement(this.sqlFilter(sql));
            if (params.length == 1) {
                SQLExecutor.setParameter((PreparedStatement)pstmt, 1, params[0]);
            } else {
                for (int i = 0; i < params.length; ++i) {
                    SQLExecutor.setParameter((PreparedStatement)pstmt, i + 1, params[i]);
                }
            }
            int n = pstmt.executeUpdate();
            return n;
        }
        finally {
            if (pstmt != null && !pstmt.isClosed()) {
                pstmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeWithGeneratedKey(String sql) throws SQLException, IllegalArgumentException {
        this.checkSQL(sql);
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            if (stmt.executeUpdate(this.sqlFilter(sql)) > 0 && (rs = stmt.getGeneratedKeys()) != null && rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
            if (stmt != null && !stmt.isClosed()) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long executeWithGeneratedKey(String sql, Object ... params) throws SQLException, IllegalArgumentException {
        this.checkSQL(sql);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = this.conn.prepareStatement(this.sqlFilter(sql), 1);
            if (params.length == 1) {
                SQLExecutor.setParameter(pstmt, 1, params[0]);
            } else {
                for (int i = 0; i < params.length; ++i) {
                    SQLExecutor.setParameter(pstmt, i + 1, params[i]);
                }
            }
            if (pstmt.executeUpdate() > 0 && (rs = pstmt.getGeneratedKeys()) != null && rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
            if (pstmt != null && !pstmt.isClosed()) {
                pstmt.close();
            }
        }
    }

    public void close() throws SQLException {
        if (!this.conn.isClosed()) {
            this.conn.close();
        }
    }

    private void checkSQL(String sql) throws IllegalArgumentException {
        if (StringUtil.isNullOrEmpty(sql)) {
            throw new IllegalArgumentException("SQL must not be null.");
        }
    }

    private String sqlFilter(String srcSQL) {
        return srcSQL.endsWith(";") ? srcSQL.substring(0, srcSQL.length() - 1) : srcSQL;
    }

    private static void setParameter(PreparedStatement pstmt, int i, Object obj) throws SQLException {
        if (obj instanceof java.util.Date) {
            if (obj instanceof Date) {
                pstmt.setDate(i, (Date)obj);
            } else if (obj instanceof Time) {
                pstmt.setTime(i, (Time)obj);
            } else {
                pstmt.setTimestamp(i, SqlTypeUtil.toSqlTimestamp((java.util.Date)obj));
            }
        } else if (obj instanceof Number) {
            if (obj instanceof BigDecimal) {
                pstmt.setBigDecimal(i, (BigDecimal)obj);
            } else if (obj instanceof BigInteger) {
                pstmt.setBigDecimal(i, new BigDecimal((BigInteger)obj));
            } else if (obj instanceof Byte) {
                pstmt.setByte(i, (Byte)obj);
            } else if (obj instanceof Short) {
                pstmt.setShort(i, (Short)obj);
            } else if (obj instanceof Integer) {
                pstmt.setInt(i, (Integer)obj);
            } else if (obj instanceof Long) {
                pstmt.setLong(i, (Long)obj);
            } else if (obj instanceof Float) {
                pstmt.setFloat(i, ((Float)obj).floatValue());
            } else if (obj instanceof Double) {
                pstmt.setDouble(i, (Double)obj);
            } else {
                pstmt.setString(i, obj.toString());
            }
        } else if (obj instanceof String) {
            pstmt.setString(i, (String)obj);
        } else {
            pstmt.setObject(i, obj);
        }
    }
}

