/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils.reflect;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import org.seppiko.commons.utils.reflect.TypeAndValue;

public class TypeUtil {
    private TypeUtil() {
    }

    public static Class<?> checkType(Object obj) {
        if (Objects.isNull(obj)) {
            return null;
        }
        if (obj.getClass().isPrimitive()) {
            if (obj instanceof Boolean) {
                return Boolean.TYPE;
            }
            if (obj instanceof Byte) {
                return Byte.TYPE;
            }
            if (obj instanceof Short) {
                return Short.TYPE;
            }
            if (obj instanceof Integer) {
                return Integer.TYPE;
            }
            if (obj instanceof Long) {
                return Long.TYPE;
            }
            if (obj instanceof Float) {
                return Float.TYPE;
            }
            if (obj instanceof Double) {
                return Double.TYPE;
            }
            if (obj instanceof Character) {
                return Character.TYPE;
            }
        }
        throw new IllegalArgumentException("Not found type");
    }

    public static Class<?> wrapper(Class<?> type) {
        if (Objects.isNull(type)) {
            return null;
        }
        if (type.isPrimitive()) {
            if (Boolean.TYPE == type) {
                return Boolean.class;
            }
            if (Byte.TYPE == type) {
                return Byte.class;
            }
            if (Short.TYPE == type) {
                return Short.class;
            }
            if (Integer.TYPE == type) {
                return Integer.class;
            }
            if (Long.TYPE == type) {
                return Long.class;
            }
            if (Float.TYPE == type) {
                return Float.class;
            }
            if (Double.TYPE == type) {
                return Double.class;
            }
            if (Character.TYPE == type) {
                return Character.class;
            }
        }
        return type;
    }

    public static TypeAndValue<?> parserNumberType(Number number) {
        if (number instanceof BigInteger) {
            return new TypeAndValue<BigInteger>(BigInteger.class, (BigInteger)number);
        }
        if (number instanceof BigDecimal) {
            return new TypeAndValue<BigDecimal>(BigDecimal.class, (BigDecimal)number);
        }
        if (number instanceof Byte) {
            return new TypeAndValue<Byte>(Byte.class, number.byteValue());
        }
        if (number instanceof Short) {
            return new TypeAndValue<Short>(Short.class, number.shortValue());
        }
        if (number instanceof Integer) {
            return new TypeAndValue<Integer>(Integer.class, number.intValue());
        }
        if (number instanceof Long) {
            return new TypeAndValue<Long>(Long.class, number.longValue());
        }
        if (number instanceof Float) {
            return new TypeAndValue<Float>(Float.class, Float.valueOf(number.floatValue()));
        }
        if (number instanceof Double) {
            return new TypeAndValue<Double>(Double.class, number.doubleValue());
        }
        throw new IllegalArgumentException("Not found number " + number + " of type " + number.getClass());
    }

    public static <T> T convertObject(Object obj, Class<T> type) throws NullPointerException, IllegalArgumentException {
        if (Objects.isNull(obj)) {
            throw new NullPointerException();
        }
        if (obj.getClass().equals(type)) {
            return (T)obj;
        }
        throw new IllegalArgumentException();
    }
}

