/*
 * Copyright 2024 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.seppiko.commons.utils.concurrent;

import java.util.concurrent.TimeUnit;

/**
 * A task that returns a result.
 * Implementors define a single method with no arguments retry caller.
 *
 * @param <V> callable type.
 * @author Leonard Woo
 */
@FunctionalInterface
public interface RetryCallable<V> {

  /**
   * Retry caller task
   *
   * @see RetryableTask#caller(RetryCallable, int, long, TimeUnit)
   * @return task callable result.
   */
  V call();
}
