/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Supplier;

public class ArrayUtil {
    private ArrayUtil() {
    }

    public static <T> boolean isArray(T obj) {
        return Objects.nonNull(obj) && obj.getClass().isArray();
    }

    public static <T> boolean isEmpty(T[] array) {
        return ArrayUtil.isNull(array) || array.length == 0;
    }

    public static <T> boolean isNull(T[] obj) {
        return null == obj;
    }

    public static <T> boolean nonNull(T[] obj) {
        return null != obj;
    }

    public static <T> T[] swap(T[] oriTs, int a, int b) {
        T tmp = oriTs[a];
        oriTs[a] = oriTs[b];
        oriTs[b] = tmp;
        return oriTs;
    }

    public static Object[] getSuppliers(Supplier<Object>[] suppliers) throws NullPointerException {
        Objects.requireNonNull(suppliers);
        return Arrays.stream(suppliers).filter(Objects::nonNull).map(Supplier::get).toArray(Object[]::new);
    }

    public static <T> T[] allocate(int capacity, Class<T> type) throws IllegalArgumentException, NullPointerException {
        if (capacity < 0 || capacity > 255) {
            throw new IllegalArgumentException("capacity must be between 0 and 255.");
        }
        Objects.requireNonNull(type, "type must not be null.");
        return (Object[])Array.newInstance(type, capacity);
    }
}

