/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

public class Bits {
    private static final int BIT_OF_BYTE = 8;
    private boolean[] bits;

    public Bits() {
        this.clean();
    }

    public Bits(Bits original) {
        this.bits = original.bits;
    }

    public void putBit(boolean value, int position) {
        if (position >= 8) {
            throw new IndexOutOfBoundsException("position must be than less 8");
        }
        this.bits[position] = value;
    }

    public void putByte(byte b) {
        for (int i = 0; i < 8; ++i) {
            this.bits[i] = (1 & b >> i) != 0;
        }
    }

    public boolean[] getBits() {
        return this.bits;
    }

    public byte getByte() {
        byte b = 0;
        for (int i = 0; i < 8; ++i) {
            b = (byte)(b << 1);
            boolean bit = this.bits[i];
            if (!bit) continue;
            b = (byte)(b | 1);
        }
        return b;
    }

    public void clean() {
        this.bits = new boolean[8];
    }
}

