/*
 * Decompiled with CFR 0.152.
 */
package org.seppiko.commons.utils;

import java.nio.ByteBuffer;

public class BytesUtil {
    private BytesUtil() {
    }

    public static byte[] longToBytes(long l) {
        return ByteBuffer.allocate(8).putLong(l).array();
    }

    public static long bytesToLong(byte[] bs) {
        return BytesUtil.getByteBuffer(bs).getLong();
    }

    public static byte[] intToBytes(int i) {
        return ByteBuffer.allocate(4).putInt(i).array();
    }

    public static int bytesToInt(byte[] bs) {
        return BytesUtil.getByteBuffer(bs).getInt();
    }

    public static byte[] shortToBytes(short s) {
        return ByteBuffer.allocate(2).putShort(s).array();
    }

    public static short bytesToShort(byte[] bs) {
        return BytesUtil.getByteBuffer(bs).getShort();
    }

    public static byte[] doubleToBytes(double d) {
        return ByteBuffer.allocate(8).putDouble(d).array();
    }

    public static double bytesToDouble(byte[] bs) {
        return BytesUtil.getByteBuffer(bs).getDouble();
    }

    public static byte[] floatToBytes(float f) {
        return ByteBuffer.allocate(4).putFloat(f).array();
    }

    public static float bytesToFloat(byte[] bs) {
        return BytesUtil.getByteBuffer(bs).getFloat();
    }

    private static ByteBuffer getByteBuffer(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    public static String toBinaryString(byte b) {
        return String.format("%8s", Integer.toBinaryString(b & 0xFF)).replace(' ', '0');
    }
}

